/*
 * Decompiled with CFR 0.152.
 */
package com.aparzev.doka.ms.excel.legacy;

import com.aparzev.doka.ms.excel.legacy.SpreadSheetSchema;
import com.aparzev.doka.ms.excel.legacy.SpreadSheetSchemaColumn;
import com.aparzev.doka.ms.excel.legacy.SpreadSheetSchemaReaderException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SpreadSheetSchemaReader {
    public SpreadSheetSchema readSchema(String path) throws SpreadSheetSchemaReaderException {
        try {
            File file = this.findFile(path);
            if (!file.exists()) {
                throw new SpreadSheetSchemaReaderException("Spreadsheet " + path + " does not exist", 1);
            }
            Element spreadSheetNode = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file).getDocumentElement();
            if (spreadSheetNode.getNodeType() != 1 || spreadSheetNode.getNodeName() != "spreadsheet") {
                throw new SpreadSheetSchemaReaderException("Expected spreadsheet node, found " + spreadSheetNode.getNodeName(), 3);
            }
            SpreadSheetSchema spreadSheet = this.getSpreadSheet(spreadSheetNode);
            return spreadSheet;
        }
        catch (ParserConfigurationException e) {
            throw new SpreadSheetSchemaReaderException("ParserConfigurationException reading spreadsheet schema: " + e, 3);
        }
        catch (SAXException e) {
            throw new SpreadSheetSchemaReaderException("SAXException reading spreadsheet schema: " + e, 3);
        }
        catch (IOException e) {
            throw new SpreadSheetSchemaReaderException("IOException reading spreadsheet schema: " + e, 2);
        }
    }

    private SpreadSheetSchema getSpreadSheet(Node node) throws SpreadSheetSchemaReaderException {
        int mappingRow;
        int rowOffset;
        NamedNodeMap attributes = node.getAttributes();
        Node nameNode = attributes.getNamedItem("name");
        Node rowOffsetNode = attributes.getNamedItem("rowOffset");
        Node mappingRowNode = attributes.getNamedItem("mappingRow");
        if (nameNode == null) {
            throw new SpreadSheetSchemaReaderException("Expected name attribute!", 3);
        }
        if (rowOffsetNode == null) {
            throw new SpreadSheetSchemaReaderException("Expected rowOffset attribute!", 3);
        }
        if (mappingRowNode == null) {
            throw new SpreadSheetSchemaReaderException("Expected mappingRow attribute!", 3);
        }
        String name = nameNode.getNodeValue();
        try {
            rowOffset = Integer.parseInt(rowOffsetNode.getNodeValue());
        }
        catch (NumberFormatException e) {
            throw new SpreadSheetSchemaReaderException("Invalid value for rowOffset attribute: " + rowOffsetNode.getNodeValue(), 4);
        }
        try {
            mappingRow = Integer.parseInt(mappingRowNode.getNodeValue());
        }
        catch (NumberFormatException e) {
            throw new SpreadSheetSchemaReaderException("Invalid value for mappingRow attribute: " + mappingRowNode.getNodeValue(), 4);
        }
        SpreadSheetSchema spreadSheet = new SpreadSheetSchema(name, rowOffset, mappingRow);
        Node columnsNode = null;
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1 || !"columns".equals(childNode.getNodeName())) continue;
            columnsNode = childNode;
            break;
        }
        if (columnsNode == null && nameNode == null) {
            throw new SpreadSheetSchemaReaderException("Expected columns node!", 3);
        }
        spreadSheet.setColumns(this.getColumns(columnsNode));
        return spreadSheet;
    }

    private List getColumns(Node node) throws SpreadSheetSchemaReaderException {
        ArrayList<SpreadSheetSchemaColumn> columns = new ArrayList<SpreadSheetSchemaColumn>();
        NodeList childNodes = node.getChildNodes();
        int index = 0;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node columnNode = childNodes.item(i);
            if (columnNode.getNodeType() != 1 || !"column".equals(columnNode.getNodeName())) continue;
            NamedNodeMap attributes = columnNode.getAttributes();
            Node nameNode = attributes.getNamedItem("name");
            Node captionNode = attributes.getNamedItem("caption");
            Node typeNode = attributes.getNamedItem("type");
            if (nameNode == null || captionNode == null || typeNode == null) {
                throw new SpreadSheetSchemaReaderException("Invalid column node!", 3);
            }
            String name = nameNode.getNodeValue();
            String caption = captionNode.getNodeValue();
            String type = typeNode.getNodeValue();
            SpreadSheetSchemaColumn column = new SpreadSheetSchemaColumn(name);
            column.setCaption(caption);
            column.setType(type);
            column.setIndex(index);
            columns.add(column);
            ++index;
        }
        return columns;
    }

    private File findFile(String fileName) {
        URL url = this.getClass().getClassLoader().getResource(fileName);
        return new File(url.getFile());
    }

    public static void main(String[] args) {
        SpreadSheetSchemaReader reader = new SpreadSheetSchemaReader();
        try {
            reader.readSchema(args[0]);
        }
        catch (SpreadSheetSchemaReaderException e) {
            System.out.println(e.getMessage());
        }
    }
}

