/*
 * Decompiled with CFR 0.152.
 */
package com.aparzev.doka.ms.excel.legacy;

import com.aparzev.doka.ms.excel.legacy.SpreadSheetData;
import com.aparzev.doka.ms.excel.legacy.SpreadSheetSchema;
import com.aparzev.doka.ms.excel.legacy.SpreadSheetSchemaColumn;
import com.aparzev.doka.ms.excel.legacy.SpreadSheetWriterException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.Label;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

public class SpreadSheetWriter {
    private static int MAX_COL_WIDTH = 150;
    private int[] colWidths;
    private SpreadSheetSchema schema;
    private List columnMapping;

    public SpreadSheetWriter(SpreadSheetSchema schema) {
        if (schema == null) {
            throw new NullPointerException("schema must not be null");
        }
        this.schema = schema;
        this.colWidths = new int[schema.getColumnCount()];
    }

    public void writeSpreadSheet(SpreadSheetData data, OutputStream stream) throws SpreadSheetWriterException {
        WritableWorkbook workbook = null;
        try {
            workbook = Workbook.createWorkbook(stream);
            WritableSheet sheet = workbook.createSheet(this.schema.getName(), 0);
            this.writeColumnHeaders(sheet);
            this.writeRows(sheet, data);
            workbook.write();
            workbook.close();
        }
        catch (WriteException e) {
            throw new SpreadSheetWriterException("Unable to write workbook!", 2);
        }
        catch (IOException e) {
            throw new SpreadSheetWriterException("Unable to write into output stream!", 1);
        }
    }

    private void writeColumnHeaders(WritableSheet sheet) throws WriteException {
        List columns = this.schema.getColumns();
        WritableFont font = new WritableFont(WritableFont.ARIAL, 10);
        WritableCellFormat format = new WritableCellFormat(font);
        format.setBackground(Colour.GOLD);
        format.setAlignment(Alignment.CENTRE);
        Iterator iter = columns.iterator();
        while (iter.hasNext()) {
            SpreadSheetSchemaColumn column = (SpreadSheetSchemaColumn)iter.next();
            Label label = new Label(column.getIndex(), 0, column.getCaption(), (CellFormat)format);
            this.colWidths[column.getIndex()] = column.getCaption().length();
            sheet.addCell(label);
        }
    }

    private void writeRows(WritableSheet sheet, SpreadSheetData data) throws WriteException, SpreadSheetWriterException {
        WritableFont font = new WritableFont(WritableFont.ARIAL, 10);
        WritableCellFormat format = new WritableCellFormat(font);
        for (int row = 0; row < data.getRowCount(); ++row) {
            for (int col = 0; col < this.schema.getColumnCount(); ++col) {
                try {
                    int width;
                    SpreadSheetSchemaColumn column = this.schema.getColumn(col);
                    String field = data.getField(row, column.getName());
                    Label label = new Label(column.getIndex(), row + this.schema.getRowOffset(), field, (CellFormat)format);
                    int n = width = field != null ? field.length() : 0;
                    if (width > this.colWidths[col] && width <= MAX_COL_WIDTH) {
                        this.colWidths[col] = width;
                    }
                    sheet.addCell(label);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new SpreadSheetWriterException(e.getMessage(), 2);
                }
            }
        }
        for (int col = 0; col < this.schema.getColumnCount(); ++col) {
            sheet.setColumnView(col, this.colWidths[col]);
        }
    }
}

