/*
 * Decompiled with CFR 0.152.
 */
package com.aparzev.doka.xml;

import com.aparzev.doka.xml.SelectiveNodeIterator;
import com.aparzev.doka.xml.SelectiveNodeList;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Selector {
    public static boolean getBooleanAttribute(Node node, String attributeName) {
        String attrValue = Selector.getStringAttribute(node, attributeName);
        return Boolean.valueOf(attrValue);
    }

    public static String getNodeValue(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3 && child.getNodeType() != 4) continue;
            String value = child.getNodeValue();
            if (value != null) {
                value = value.trim();
            }
            return value;
        }
        return null;
    }

    public static String getStringAttribute(Node node, String attributeName) {
        NamedNodeMap map = node.getAttributes();
        if (map == null) {
            return null;
        }
        Node attribute = map.getNamedItem(attributeName);
        if (attribute == null) {
            return null;
        }
        return attribute.getNodeValue();
    }

    public static SelectiveNodeIterator selectNodeIterator(Node parent, String childName) {
        return new SelectiveNodeIterator(parent, childName);
    }

    public static NodeList selectNodeList(Node parent, String childName) {
        return new SelectiveNodeList(parent, childName);
    }

    public static Node selectSingleNode(Node parent, String childName) {
        if (parent == null) {
            return null;
        }
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!node.getNodeName().equals(childName)) continue;
            return node;
        }
        return null;
    }

    public static Node selectSingleNode(Node parent, String childName, String attributeName, String attributeValue) {
        if (parent == null) {
            return null;
        }
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node attribute;
            NamedNodeMap map;
            Node node = list.item(i);
            if (!node.getNodeName().equals(childName) || (map = node.getAttributes()) == null || (attribute = map.getNamedItem(attributeName)) == null || !attribute.getNodeValue().equals(attributeValue)) continue;
            return node;
        }
        return null;
    }

    public static String selectSingleNodeValue(Node parent, String childName) {
        Node child = Selector.selectSingleNode(parent, childName);
        if (child == null) {
            return null;
        }
        return Selector.getNodeValue(child);
    }
}

