/*
 * Decompiled with CFR 0.152.
 */
package com.apiflows.parser;

import com.apiflows.model.Components;
import com.apiflows.model.Criterion;
import com.apiflows.model.FailureAction;
import com.apiflows.model.Info;
import com.apiflows.model.OpenAPIWorkflow;
import com.apiflows.model.Parameter;
import com.apiflows.model.SourceDescription;
import com.apiflows.model.Step;
import com.apiflows.model.SuccessAction;
import com.apiflows.model.Workflow;
import com.apiflows.parser.OpenAPIWorkflowValidatorResult;
import com.fasterxml.jackson.core.JsonPointer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class OpenAPIWorkflowValidator {
    private OpenAPIWorkflow openAPIWorkflow = null;
    Set<String> workflowIds = new HashSet<String>();
    Map<String, Set<String>> stepIds = new HashMap<String, Set<String>>();
    Set<String> operationIds = new HashSet<String>();
    Set<String> componentIds = new HashSet<String>();
    Components components = null;

    OpenAPIWorkflowValidator() {
    }

    public OpenAPIWorkflowValidator(OpenAPIWorkflow openAPIWorkflow) {
        this.openAPIWorkflow = openAPIWorkflow;
    }

    public OpenAPIWorkflowValidatorResult validate() {
        if (this.openAPIWorkflow == null) {
            throw new RuntimeException("OpenAPIWorkflow is not provided");
        }
        this.loadWorkflowIds(this.openAPIWorkflow);
        this.loadStepIds(this.openAPIWorkflow.getWorkflows());
        this.loadOperationIds(this.openAPIWorkflow);
        this.loadComponents(this.openAPIWorkflow.getComponents());
        OpenAPIWorkflowValidatorResult result = new OpenAPIWorkflowValidatorResult();
        if (this.openAPIWorkflow.getArazzo() == null || this.openAPIWorkflow.getArazzo().isEmpty()) {
            result.addError("'arazzo' is undefined");
        }
        result.addErrors(this.validateInfo(this.openAPIWorkflow.getInfo()));
        result.addErrors(this.validateSourceDescriptions(this.openAPIWorkflow.getSourceDescriptions()));
        if (this.openAPIWorkflow.getWorkflows() == null || this.openAPIWorkflow.getWorkflows().isEmpty()) {
            result.addError("'Workflows' is undefined");
        }
        if (this.openAPIWorkflow.getWorkflows() != null) {
            for (Workflow workflow : this.openAPIWorkflow.getWorkflows()) {
                int i = 0;
                result.addErrors(this.validateWorkflow(workflow, i));
                for (Step step : workflow.getSteps()) {
                    result.addErrors(this.validateStep(step, workflow.getWorkflowId()));
                }
            }
        }
        result.addErrors(this.validateComponents(this.openAPIWorkflow.getComponents()));
        if (!result.getErrors().isEmpty()) {
            result.setValid(false);
        }
        return result;
    }

    List<String> validateInfo(Info info) {
        ArrayList<String> errors = new ArrayList<String>();
        if (info == null) {
            errors.add("'Info' is undefined");
        }
        if (info != null && (info.getTitle() == null || info.getTitle().isEmpty())) {
            errors.add("'Info title' is undefined");
        }
        if (info != null && (info.getVersion() == null || info.getVersion().isEmpty())) {
            errors.add("'Info version' is undefined");
        }
        return errors;
    }

    List<String> validateSourceDescriptions(List<SourceDescription> sourceDescriptions) {
        List<String> SUPPORTED_TYPES = Arrays.asList("openapi", "arazzo");
        ArrayList<String> errors = new ArrayList<String>();
        if (sourceDescriptions == null) {
            errors.add("'SourceDescriptions' is undefined");
        }
        if (sourceDescriptions != null) {
            int i = 0;
            for (SourceDescription sourceDescription : sourceDescriptions) {
                if (sourceDescription.getName() == null || sourceDescription.getName().isEmpty()) {
                    errors.add("'SourceDescription[" + i + "] name' is undefined");
                }
                if (sourceDescription.getUrl() == null || sourceDescription.getUrl().isEmpty()) {
                    errors.add("'SourceDescription[" + i + "] url' is undefined");
                }
                if (sourceDescription.getType() != null && !SUPPORTED_TYPES.contains(sourceDescription.getType())) {
                    errors.add("'SourceDescription[" + i + "] type' is invalid");
                }
                ++i;
            }
            if (i == 0) {
                errors.add("'SourceDescriptions' is empty");
            }
        }
        return errors;
    }

    List<String> validateWorkflow(Workflow workflow, int index) {
        ArrayList<String> errors = new ArrayList<String>();
        if (workflow.getWorkflowId() == null || workflow.getWorkflowId().isEmpty()) {
            errors.add("'Workflow[" + index + "] workflowId' is undefined");
        }
        if (workflow.getWorkflowId() != null && !this.isValidWorkflowId(workflow.getWorkflowId())) {
            errors.add("WorkflowId " + workflow.getWorkflowId() + " format is invalid (should match regex " + this.getWorkflowIdRegularExpression() + ")");
        }
        if (workflow.getSteps() == null || workflow.getSteps().isEmpty()) {
            errors.add("'Workflow " + workflow.getWorkflowId() + "' no Steps are undefined");
        }
        for (String key : workflow.getOutputs().keySet()) {
            if (this.isValidOutputsKey(key)) continue;
            errors.add("Workflow[" + workflow.getWorkflowId() + "] Outputs key is invalid (should match regex " + this.getOutputsKeyRegularExpression() + ")");
        }
        return errors;
    }

    List<String> validateStep(Step step, String workflowId) {
        int numAssignedValues;
        ArrayList<String> errors = new ArrayList<String>();
        String stepId = step.getStepId();
        if (stepId == null || stepId.isEmpty()) {
            errors.add("'Workflow[" + workflowId + "] stepId' is undefined");
        }
        if (stepId != null && !this.isValidStepId(stepId)) {
            errors.add("'Step " + stepId + " is invalid (should match regex " + this.getStepIdRegularExpression() + ")");
        }
        if ((numAssignedValues = (step.getOperationId() != null ? 1 : 0) + (step.getWorkflowId() != null ? 1 : 0) + (step.getOperationPath() != null ? 1 : 0)) != 1) {
            if (stepId != null) {
                errors.add("'Step " + stepId + " should provide only one of the following: [operationId, operationPath, workflowId]");
            } else {
                errors.add("'Workflow[" + workflowId + "]' should provide only one of the following: [operationId, operationPath, workflowId]");
            }
        }
        if (step.getParameters() != null) {
            for (Parameter parameter : step.getParameters()) {
                if (this.isRuntimeExpression(parameter.getReference())) {
                    errors.addAll(this.validateReusableParameter(parameter, workflowId, null));
                    continue;
                }
                errors.addAll(this.validateParameter(parameter, workflowId, null));
                if (step.getWorkflowId() != null || this.isRuntimeExpression(parameter.getName()) || parameter.getIn() != null) continue;
                errors.add("'Workflow[" + workflowId + "]' parameter IN must be defined");
            }
        }
        if (step.getDependsOn() != null) {
            if (!this.stepExists(workflowId, step.getDependsOn())) {
                errors.add("'Step " + stepId + " 'dependsOn' is invalid (no such a step exists)");
            }
            if (step.getDependsOn().equals(stepId)) {
                errors.add("'Step " + stepId + " 'dependsOn' is invalid (same value as stepId)");
            }
        }
        for (Criterion criterion : step.getSuccessCriteria()) {
            errors.addAll(this.validateCriterion(criterion, stepId));
        }
        for (SuccessAction successAction : step.getOnSuccess()) {
            errors.addAll(this.validateSuccessAction(workflowId, stepId, successAction));
        }
        for (FailureAction failureAction : step.getOnFailure()) {
            errors.addAll(this.validateFailureAction(workflowId, stepId, failureAction));
        }
        return errors;
    }

    List<String> validateParameter(Parameter parameter, String workflowId, String componentName) {
        List<String> SUPPORTED_VALUES = Arrays.asList("path", "query", "header", "cookie", "body");
        String source = workflowId != null ? "Workflow[" + workflowId + "]" : "Component[" + componentName + "]";
        ArrayList<String> errors = new ArrayList<String>();
        String name = parameter.getName();
        if (name == null) {
            errors.add(source + " parameter has no name");
        }
        if (parameter.getIn() != null && !SUPPORTED_VALUES.contains(parameter.getIn())) {
            if (name != null) {
                errors.add(source + "parameter " + name + " in (" + parameter.getIn() + ") is invalid");
            } else {
                errors.add(source + " parameter in (" + parameter.getIn() + ") is invalid");
            }
        }
        if (parameter.getValue() == null) {
            if (name != null) {
                errors.add(source + " parameter " + name + " has no value");
            } else {
                errors.add(source + " parameter has no value");
            }
        }
        if (this.isRuntimeExpression(parameter.getName())) {
            errors.add(source + " parameter " + name + " is a Reusable Parameter object");
        }
        return errors;
    }

    List<String> validateReusableParameter(Parameter parameter, String workflowId, String componentName) {
        String source = workflowId != null ? "Workflow[" + workflowId + "]" : "Component[" + componentName + "]";
        String reference = parameter.getReference();
        String key = reference.replace("$components.parameters.", "");
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.components.getParameters().containsKey(key)) {
            errors.add(source + " parameter '" + reference + "' not found");
        }
        return errors;
    }

    List<String> validateSuccessAction(String workflowId, String stepId, SuccessAction successAction) {
        List<String> SUPPORTED_VALUES = Arrays.asList("end", "goto");
        ArrayList<String> errors = new ArrayList<String>();
        if (successAction.getType() == null) {
            errors.add("Step " + stepId + " SuccessAction has no type");
        }
        if (successAction.getType() != null && !SUPPORTED_VALUES.contains(successAction.getType())) {
            errors.add("Step " + stepId + " SuccessAction type (" + successAction.getType() + ") is invalid");
        }
        if (successAction.getWorkflowId() == null && successAction.getStepId() == null) {
            errors.add("Step " + stepId + " SuccessAction must define either workflowId or stepId");
        }
        if (successAction.getWorkflowId() != null && successAction.getStepId() != null) {
            errors.add("Step " + stepId + " SuccessAction cannot define both workflowId and stepId");
        }
        if (successAction.getStepId() != null && successAction.getType() != null && successAction.getType().equals("goto") && !this.stepExists(workflowId, successAction.getStepId())) {
            errors.add("Step " + stepId + " SuccessAction stepId is invalid (no such a step exists)");
        }
        if (successAction.getWorkflowId() != null && successAction.getType() != null && successAction.getType().equals("goto") && !this.workflowExists(workflowId)) {
            errors.add("Step " + stepId + " SuccessAction workflowId is invalid (no such a workflow exists)");
        }
        return errors;
    }

    List<String> validateFailureAction(String workflowId, String stepId, FailureAction failureAction) {
        List<String> SUPPORTED_VALUES = Arrays.asList("end", "retry", "goto");
        ArrayList<String> errors = new ArrayList<String>();
        if (failureAction.getType() == null) {
            errors.add("Step " + stepId + " FailureAction has no type");
        }
        if (failureAction.getType() != null && !SUPPORTED_VALUES.contains(failureAction.getType())) {
            errors.add("Step " + stepId + " FailureAction type (" + failureAction.getType() + ") is invalid");
        }
        if (failureAction.getWorkflowId() == null && failureAction.getStepId() == null) {
            errors.add("Step " + stepId + " FailureAction must define either workflowId or stepId");
        }
        if (failureAction.getWorkflowId() != null && failureAction.getStepId() != null) {
            errors.add("Step " + stepId + " FailureAction cannot define both workflowId and stepId");
        }
        if (failureAction.getRetryAfter() != null && failureAction.getRetryAfter() < 0L) {
            errors.add("Step " + stepId + " FailureAction retryAfter must be non-negative");
        }
        if (failureAction.getRetryLimit() != null && failureAction.getRetryLimit() < 0) {
            errors.add("Step " + stepId + " FailureAction retryLimit must be non-negative");
        }
        if (failureAction.getStepId() != null && failureAction.getType() != null && (failureAction.getType().equals("goto") || failureAction.getType().equals("retry")) && !this.stepExists(workflowId, failureAction.getStepId())) {
            errors.add("Step " + stepId + " FailureAction stepId is invalid (no such a step exists)");
        }
        return errors;
    }

    List<String> validateCriterion(Criterion criterion, String stepId) {
        List<String> SUPPORTED_VALUES = Arrays.asList("simple", "regex", "jsonpath", "xpath");
        ArrayList<String> errors = new ArrayList<String>();
        if (criterion.getCondition() == null) {
            errors.add("Step " + stepId + " has no condition");
        }
        if (criterion.getType() != null && !SUPPORTED_VALUES.contains(criterion.getType())) {
            errors.add("Step " + stepId + " SuccessCriteria type (" + criterion.getType() + ") is invalid");
        }
        if (criterion.getType() != null && criterion.getContext() == null) {
            errors.add("Step " + stepId + " SuccessCriteria type is specified but context is not provided");
        }
        return errors;
    }

    List<String> validateComponents(Components components) {
        ArrayList<String> errors = new ArrayList<String>();
        if (components != null) {
            if (components.getParameters() != null) {
                for (String key : components.getParameters().keySet()) {
                    if (this.isValidComponentKey(key)) continue;
                    errors.add("'Component parameter name " + key + " is invalid (should match regex " + this.getComponentKeyRegularExpression() + ")");
                }
                components.getParameters().entrySet().stream().forEach(entry -> errors.addAll(this.validateParameter((Parameter)entry.getValue(), null, (String)entry.getKey())));
            }
            if (components.getInputs() != null) {
                for (String key : components.getInputs().keySet()) {
                    if (this.isValidComponentKey(key)) continue;
                    errors.add("'Component input " + key + " is invalid (should match regex " + this.getComponentKeyRegularExpression() + ")");
                }
            }
        }
        return errors;
    }

    boolean isValidWorkflowId(String workflowId) {
        return Pattern.matches(this.getWorkflowIdRegularExpression(), workflowId);
    }

    boolean isValidStepId(String stepId) {
        return Pattern.matches(this.getStepIdRegularExpression(), stepId);
    }

    boolean isValidComponentKey(String key) {
        return Pattern.matches(this.getComponentKeyRegularExpression(), key);
    }

    String getStepIdRegularExpression() {
        return "[A-Za-z0-9_\\-]+";
    }

    String getWorkflowIdRegularExpression() {
        return "[A-Za-z0-9_\\\\-]++";
    }

    String getComponentKeyRegularExpression() {
        return "^[a-zA-Z0-9\\.\\-_]+$";
    }

    boolean isValidOutputsKey(String key) {
        return Pattern.matches(this.getOutputsKeyRegularExpression(), key);
    }

    String getOutputsKeyRegularExpression() {
        return "^[a-zA-Z0-9\\.\\-_]+$";
    }

    List<String> loadWorkflowIds(OpenAPIWorkflow openAPIWorkflow) {
        boolean multipleSpecs;
        ArrayList<String> errors = new ArrayList<String>();
        boolean bl = multipleSpecs = this.getNumArazzoTypeSourceDescriptions(openAPIWorkflow.getSourceDescriptions()) > 1;
        if (openAPIWorkflow.getWorkflows() != null) {
            this.validateWorkflowIdsUniqueness(openAPIWorkflow.getWorkflows());
            for (Workflow workflow : openAPIWorkflow.getWorkflows()) {
                errors.addAll(this.validateStepsWorkflowIds(workflow.getSteps(), multipleSpecs));
            }
            for (Workflow workflow : openAPIWorkflow.getWorkflows()) {
                this.workflowIds.add(workflow.getWorkflowId());
            }
        }
        return errors;
    }

    List<String> loadStepIds(List<Workflow> workflows) {
        ArrayList<String> errors = new ArrayList<String>();
        if (workflows != null) {
            for (Workflow workflow : workflows) {
                Set<String> steps = this.stepIds.get(workflow.getWorkflowId());
                if (steps == null) {
                    steps = new HashSet<String>();
                }
                for (Step step : workflow.getSteps()) {
                    if (steps.add(step.getStepId())) continue;
                    errors.add("StepId is not unique: " + step.getStepId());
                }
                this.stepIds.put(workflow.getWorkflowId(), steps);
            }
        }
        return errors;
    }

    List<String> loadOperationIds(OpenAPIWorkflow openAPIWorkflow) {
        ArrayList<String> errors = new ArrayList<String>();
        boolean multipleOpenApiFiles = this.getNumOpenApiSourceDescriptions(openAPIWorkflow.getSourceDescriptions()) > 1;
        for (Workflow workflow : openAPIWorkflow.getWorkflows()) {
            errors.addAll(this.validateStepsOperationIds(workflow.getSteps(), multipleOpenApiFiles));
            for (Step step : workflow.getSteps()) {
                if (step.getOperationId() == null) continue;
                this.operationIds.add(step.getOperationId());
            }
        }
        return errors;
    }

    void loadComponents(Components components) {
        this.components = components;
    }

    public List<String> validateStepsOperationIds(List<Step> steps, boolean multipleOpenApiFiles) {
        ArrayList<String> errors = new ArrayList<String>();
        for (Step step : steps) {
            if (!multipleOpenApiFiles || step.getOperationId() == null || step.getOperationId().startsWith("$sourceDescriptions.")) continue;
            errors.add("Operation " + step.getOperationId() + " must be specified using a runtime expression (e.g., $sourceDescriptions.<name>.<operationId>)");
        }
        return errors;
    }

    int getNumOpenApiSourceDescriptions(List<SourceDescription> sourceDescriptions) {
        return (int)sourceDescriptions.stream().filter(p -> p.isOpenApi()).count();
    }

    int getNumArazzoTypeSourceDescriptions(List<SourceDescription> sourceDescriptions) {
        return (int)sourceDescriptions.stream().filter(p -> p.isArazzo()).count();
    }

    boolean stepExists(String workflowId, String stepId) {
        return this.stepIds.get(workflowId) != null && this.stepIds.get(workflowId).contains(stepId);
    }

    boolean workflowExists(String workflowId) {
        return this.workflowIds.stream().anyMatch(p -> p.contains(workflowId));
    }

    List<String> validateWorkflowIdsUniqueness(List<Workflow> workflows) {
        ArrayList<String> errors = new ArrayList<String>();
        HashSet<String> ids = new HashSet<String>();
        for (Workflow workflow : workflows) {
            if (ids.add(workflow.getWorkflowId())) continue;
            errors.add("WorkflowId is not unique: " + workflow.getWorkflowId());
        }
        return errors;
    }

    List<String> validateStepsWorkflowIds(List<Step> steps, boolean multipleArazzoTypeFiles) {
        ArrayList<String> errors = new ArrayList<String>();
        for (Step step : steps) {
            if (!multipleArazzoTypeFiles || step.getWorkflowId() == null || step.getWorkflowId().startsWith("$sourceDescriptions.")) continue;
            errors.add("Operation " + step.getWorkflowId() + " must be specified using a runtime expression (e.g., $sourceDescriptions.<name>.<workflowId>)");
        }
        return errors;
    }

    public boolean isValidJsonPointer(String jsonPointerString) {
        boolean ret;
        try {
            JsonPointer jsonPointer = JsonPointer.compile((String)jsonPointerString);
            ret = true;
        }
        catch (IllegalArgumentException e) {
            ret = false;
        }
        return ret;
    }

    boolean isRuntimeExpression(String name) {
        return name != null && name.startsWith("$");
    }
}

