/*
 * Decompiled with CFR 0.152.
 */
package com.apiflows.parser.source;

import com.apiflows.model.OpenAPIWorkflow;
import com.apiflows.model.SourceDescription;
import com.apiflows.model.Step;
import com.apiflows.model.Workflow;
import com.apiflows.parser.util.HttpUtil;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationBinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationBinder.class);

    public void bind(OpenAPIWorkflow openAPIWorkflow, String location) {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        for (SourceDescription source : openAPIWorkflow.getSourceDescriptions()) {
            if (!source.isOpenApi()) continue;
            if (new HttpUtil().isUrl(source.getUrl())) {
                operations.addAll(this.getOperations(source.getUrl()));
                continue;
            }
            String filename = this.getRootFolder(location) + source.getUrl();
            operations.addAll(this.getOperations(filename));
        }
        for (Workflow workflow : openAPIWorkflow.getWorkflows()) {
            for (Step step : workflow.getSteps()) {
                if (step.getOperationId() != null) {
                    step.setOperation(this.findOperationById(step.getOperationId(), operations));
                    continue;
                }
                if (step.getOperationPath() == null) continue;
                step.setOperation(this.findOperationByRef(step.getOperationPath(), operations));
            }
        }
    }

    List<Operation> getOperations(String openapi) {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        OpenAPIV3Parser openApiParser = new OpenAPIV3Parser();
        ParseOptions options = new ParseOptions();
        options.setResolve(true);
        SwaggerParseResult parseResult = null;
        try {
            parseResult = openApiParser.readLocation(openapi, null, options);
        }
        catch (Exception e) {
            LOGGER.error("Cannot find or parse source description: " + openapi, (Throwable)e);
            throw new RuntimeException("Cannot find or parse source description: " + openapi);
        }
        if (parseResult == null || parseResult.getOpenAPI() == null) {
            LOGGER.error("Cannot find or parse source description: " + openapi);
            throw new RuntimeException("Cannot parse source description: " + openapi);
        }
        OpenAPI openAPI = parseResult.getOpenAPI();
        for (PathItem pathItem : openAPI.getPaths().values()) {
            operations.addAll(pathItem.readOperations());
        }
        return operations;
    }

    Operation findOperationById(String operationId, List<Operation> operations) {
        Operation operation = null;
        for (Operation o : operations) {
            if (operationId == null || !operationId.equals(o.getOperationId())) continue;
            operation = o;
        }
        return operation;
    }

    Operation findOperationByRef(String operationRef, List<Operation> operations) {
        Operation operation = null;
        return operation;
    }

    String getRootFolder(String location) {
        if (location == null) {
            return "";
        }
        if (this.isUrl(location)) {
            return location.substring(0, location.lastIndexOf("/") + 1) + "/";
        }
        Path filePath = Paths.get(location, new String[0]);
        return filePath.getParent() != null ? filePath.getParent().toString() + "/" : null;
    }

    boolean isUrl(String url) {
        return url != null && url.startsWith("http");
    }
}

