/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.yaml.printer;

import com.apicatalog.yaml.printer.DoubleQuotedPrinter;
import com.apicatalog.yaml.printer.FoldedPrinter;
import com.apicatalog.yaml.printer.IndentedPrinter;
import com.apicatalog.yaml.printer.SingleQuotedPrinter;
import com.apicatalog.yaml.printer.YamlCharacters;
import com.apicatalog.yaml.printer.YamlPrinter;
import com.apicatalog.yaml.writer.YamlPrintStyle;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Deque;

public class DefaultYamlPrinter
implements YamlPrinter {
    protected final IndentedPrinter printer;
    protected final YamlPrintStyle style;
    private final Deque<Context> context;

    public DefaultYamlPrinter(Writer writer, YamlPrintStyle style) {
        this.printer = new IndentedPrinter(writer);
        this.style = style;
        this.context = new ArrayDeque<Context>(10);
        this.context.push(Context.DOCUMENT_BEGIN);
    }

    protected YamlPrinter beginBlockScalar() throws IOException {
        if (Context.BLOCK_SEQUENCE.equals((Object)this.context.peek())) {
            this.printer.print('-');
            this.printer.print(' ');
        } else if (Context.BLOCK_MAPPING_VALUE.equals((Object)this.context.peek())) {
            this.printer.print(' ');
        } else if (Context.DOCUMENT_BEGIN.equals((Object)this.context.peek())) {
            this.context.pop();
            this.context.push(Context.DOCUMENT_END);
        } else {
            throw new IllegalStateException();
        }
        return this;
    }

    protected YamlPrinter endBlockScalar() throws IOException {
        if (Context.BLOCK_MAPPING_VALUE.equals((Object)this.context.peek())) {
            this.context.pop();
            this.context.push(Context.BLOCK_MAPPING_KEY);
        } else if (Context.BLOCK_MAPPING_KEY.equals((Object)this.context.peek())) {
            this.printer.print(':');
            this.context.pop();
            this.context.push(Context.BLOCK_MAPPING_VALUE);
        }
        return this;
    }

    protected void printChomping(char[] chars, int offset, int length) throws IOException {
        int trailingNl = 0;
        for (int i = length - 1; i >= 0 && '\n' == chars[offset + i]; --i) {
            ++trailingNl;
        }
        if (trailingNl != 0 && trailingNl > 1) {
            this.printer.print('+');
        }
    }

    @Override
    public YamlPrinter printLiteralScalar(char[] chars, int offset, int length) throws IOException {
        this.beginBlockScalar();
        this.printer.print('|');
        this.printChomping(chars, offset, length);
        this.printer.println();
        this.printer.beginBlock();
        int begin = 0;
        boolean empty = true;
        for (int i = 0; i < length; ++i) {
            if ('\n' == chars[i + offset]) {
                if (!empty) {
                    this.printer.print(chars, offset + begin, i - begin);
                }
                this.printer.println();
                begin = i + 1;
                empty = true;
                continue;
            }
            empty = empty && ' ' == chars[i + offset];
        }
        if (begin < length && !empty) {
            this.printer.print(chars, offset + begin, length - begin);
        }
        this.printer.endBlock();
        return this.endBlockScalar();
    }

    @Override
    public YamlPrinter printFoldedScalar(char[] chars, int offset, int length) throws IOException {
        this.beginBlockScalar();
        this.printer.print('>');
        this.printChomping(chars, offset, length);
        this.printer.println();
        this.printer.beginBlock();
        new FoldedPrinter(this.printer).print(this.style.getMaxLineLength() - this.printer.indentation(), chars, offset, length);
        this.printer.endBlock();
        return this.endBlockScalar();
    }

    @Override
    public final YamlPrinter printScalar(char[] chars, int offset, int length) throws IOException {
        int maxLineLength = this.style.getMaxLineLength() - this.printer.indentation();
        boolean includesControl = false;
        int wsCount = 0;
        int nlCount = 0;
        int nlLastIndex = 0;
        int nlMaxDistance = -1;
        for (int i = 0; i < length; ++i) {
            char ch = chars[i + offset];
            if (YamlCharacters.IS_PRINTABLE.negate().test(Character.valueOf(ch))) {
                return this.printDoubleQuotedScalar(chars, offset, length);
            }
            if (!includesControl) {
                includesControl = YamlCharacters.IS_CONTROL.test(Character.valueOf(ch));
            }
            if ('\n' == ch) {
                ++nlCount;
                nlMaxDistance = Math.max(nlMaxDistance, i - nlLastIndex);
                nlLastIndex = i;
                continue;
            }
            if (' ' != ch) continue;
            ++wsCount;
        }
        if (' ' == chars[offset] || ' ' == chars[offset + length - 1]) {
            return Context.BLOCK_MAPPING_KEY.equals((Object)this.context.peek()) || nlCount > 0 ? this.printDoubleQuotedScalar(chars, offset, length) : this.printSingleQuotedScalar(chars, offset, length);
        }
        if (wsCount + nlCount > length / 2) {
            return this.printDoubleQuotedScalar(chars, offset, length);
        }
        if (nlCount == 0 && includesControl && length < maxLineLength && (Context.BLOCK_MAPPING_VALUE.equals((Object)this.context.peek()) || Context.BLOCK_SEQUENCE.equals((Object)this.context.peek()) || Context.DOCUMENT_END.equals((Object)this.context.peek()))) {
            return DefaultYamlPrinter.isURI(chars, offset, length) ? this.printPlainScalar(chars, offset, length) : this.printSingleQuotedScalar(chars, offset, length);
        }
        if (this.isDocumentContext()) {
            if (nlCount == 0 && length < maxLineLength) {
                return includesControl ? this.printSingleQuotedScalar(chars, offset, length) : this.printPlainScalar(chars, offset, length);
            }
            if (nlMaxDistance <= maxLineLength) {
                if (includesControl) {
                    return nlCount > 1 ? this.printLiteralScalar(chars, offset, length) : this.printSingleQuotedScalar(chars, offset, length);
                }
                return this.printPlainScalar(chars, offset, length);
            }
            return this.printFoldedScalar(chars, offset, length);
        }
        if (nlCount == 0 && (length < maxLineLength || Context.BLOCK_MAPPING_KEY.equals((Object)this.context.peek()))) {
            return includesControl ? this.printSingleQuotedScalar(chars, offset, length) : this.printPlainScalar(chars, offset, length);
        }
        if (!Context.BLOCK_MAPPING_KEY.equals((Object)this.context.peek())) {
            if (nlMaxDistance <= maxLineLength) {
                return nlCount > 1 ? this.printLiteralScalar(chars, offset, length) : this.printSingleQuotedScalar(chars, offset, length);
            }
            return this.printFoldedScalar(chars, offset, length);
        }
        return this.printDoubleQuotedScalar(chars, offset, length);
    }

    @Override
    public YamlPrinter beginBlockSequence() throws IOException {
        boolean newBlock;
        if (Context.BLOCK_SEQUENCE.equals((Object)this.context.peek())) {
            this.printer.print('-');
            if (this.style.isCompactArrays()) {
                this.printer.print(' ');
            } else {
                this.printer.println();
            }
            newBlock = true;
        } else if (Context.BLOCK_MAPPING_VALUE.equals((Object)this.context.peek())) {
            this.printer.println();
            newBlock = true;
        } else if (Context.DOCUMENT_BEGIN.equals((Object)this.context.peek())) {
            this.context.pop();
            this.context.push(Context.DOCUMENT_END);
            newBlock = false;
        } else {
            throw new IllegalStateException();
        }
        this.context.push(Context.BLOCK_SEQUENCE);
        if (newBlock) {
            this.printer.beginBlock();
        }
        return this;
    }

    @Override
    public YamlPrinter endBlockSequence() {
        if (!Context.BLOCK_SEQUENCE.equals((Object)this.context.peek())) {
            throw new IllegalStateException();
        }
        this.context.pop();
        this.endCollection();
        return this;
    }

    @Override
    public YamlPrinter beginBlockMapping() throws IOException {
        boolean newBlock;
        if (Context.BLOCK_SEQUENCE.equals((Object)this.context.peek())) {
            this.printer.print('-');
            if (this.style.isCompactArrays()) {
                this.printer.print(' ');
            } else {
                this.printer.println();
            }
            newBlock = true;
        } else if (Context.BLOCK_MAPPING_VALUE.equals((Object)this.context.peek())) {
            this.printer.println();
            newBlock = true;
        } else if (Context.DOCUMENT_BEGIN.equals((Object)this.context.peek())) {
            this.context.pop();
            this.context.push(Context.DOCUMENT_END);
            newBlock = false;
        } else {
            throw new IllegalStateException();
        }
        this.context.push(Context.BLOCK_MAPPING_KEY);
        if (newBlock) {
            this.printer.beginBlock();
        }
        return this;
    }

    @Override
    public YamlPrinter endBlockdMapping() {
        if (!Context.BLOCK_MAPPING_KEY.equals((Object)this.context.peek()) && !Context.BLOCK_MAPPING_VALUE.equals((Object)this.context.peek())) {
            throw new IllegalStateException();
        }
        this.context.pop();
        this.endCollection();
        return this;
    }

    @Override
    public YamlPrinter printDoubleQuotedScalar(char[] chars, int offset, int length) throws IOException {
        this.beginFlowScalar(false);
        this.printer.print('\"');
        this.printer.beginFlow();
        if (Context.BLOCK_MAPPING_KEY.equals((Object)this.context.peek())) {
            new DoubleQuotedPrinter(this.printer).printInline(chars, offset, length);
        } else {
            new DoubleQuotedPrinter(this.printer).printFolded(this.style.getMaxLineLength() - this.printer.indentation(), chars, offset, length);
        }
        this.printer.print('\"');
        this.printer.endFlow();
        return this.endFlowScalar();
    }

    @Override
    public YamlPrinter printSingleQuotedScalar(char[] chars, int offset, int length) throws IOException {
        this.beginFlowScalar(false);
        this.printer.print('\'');
        this.printer.beginFlow();
        new SingleQuotedPrinter(this.printer).print(this.style.getMaxLineLength() - this.printer.indentation(), chars, offset, length);
        this.printer.print('\'');
        this.printer.endFlow();
        return this.endFlowScalar();
    }

    @Override
    public YamlPrinter printPlainScalar(char[] chars, int offset, int length) throws IOException {
        this.beginFlowScalar(false);
        this.printer.beginFlow();
        int maxLineLength = Math.max(0, this.style.getMaxLineLength() - this.printer.indentation());
        int lineIndex = 0;
        int lastSpaceIndex = 0;
        for (int i = 0; i < length; ++i) {
            if ('\n' == chars[i + offset]) {
                if (i > lineIndex) {
                    this.printer.print(chars, offset + lineIndex, i - lineIndex);
                }
                this.printer.println();
                this.printer.println();
                lineIndex = i + 1;
                lastSpaceIndex = i + 1;
                continue;
            }
            if (' ' == chars[i + offset]) {
                lastSpaceIndex = i + 1;
                continue;
            }
            if (i - lineIndex < maxLineLength || lastSpaceIndex - lineIndex <= 1) continue;
            this.printer.print(chars, offset + lineIndex, lastSpaceIndex - lineIndex - 1);
            this.printer.println();
            lineIndex = lastSpaceIndex;
        }
        if (lineIndex < length) {
            this.printer.print(chars, offset + lineIndex, length - lineIndex);
        }
        this.printer.endFlow();
        return this.endFlowScalar();
    }

    @Override
    public YamlPrinter printNull() throws IOException {
        if (Context.BLOCK_MAPPING_KEY.equals((Object)this.context.peek())) {
            throw new IllegalStateException();
        }
        this.beginFlowScalar(true);
        this.endFlowScalar();
        return this;
    }

    protected void beginFlowScalar(boolean empty) throws IOException {
        if (Context.BLOCK_SEQUENCE.equals((Object)this.context.peek())) {
            this.printer.print('-');
            if (!empty) {
                this.printer.print(' ');
            }
        } else if (!empty && Context.BLOCK_MAPPING_VALUE.equals((Object)this.context.peek())) {
            this.printer.print(' ');
        } else if (Context.DOCUMENT_BEGIN.equals((Object)this.context.peek())) {
            this.context.pop();
            this.context.push(Context.DOCUMENT_END);
        } else if (!Context.BLOCK_MAPPING_KEY.equals((Object)this.context.peek()) && !Context.BLOCK_MAPPING_VALUE.equals((Object)this.context.peek())) {
            throw new IllegalStateException();
        }
    }

    protected YamlPrinter endFlowScalar() throws IOException {
        if (Context.BLOCK_SEQUENCE.equals((Object)this.context.peek())) {
            this.printer.println();
        } else if (Context.BLOCK_MAPPING_VALUE.equals((Object)this.context.peek())) {
            this.printer.println();
            this.context.pop();
            this.context.push(Context.BLOCK_MAPPING_KEY);
        } else if (Context.BLOCK_MAPPING_KEY.equals((Object)this.context.peek())) {
            this.printer.print(':');
            this.context.pop();
            this.context.push(Context.BLOCK_MAPPING_VALUE);
        }
        return this;
    }

    protected void endCollection() {
        if (Context.BLOCK_SEQUENCE.equals((Object)this.context.peek())) {
            this.printer.endBlock();
        } else if (Context.BLOCK_MAPPING_VALUE.equals((Object)this.context.peek())) {
            this.printer.endBlock();
            this.context.pop();
            this.context.push(Context.BLOCK_MAPPING_KEY);
        }
    }

    @Override
    public void close() throws IOException {
        this.printer.close();
    }

    private final boolean isDocumentContext() {
        return Context.DOCUMENT_BEGIN.equals((Object)this.context.peek()) || Context.DOCUMENT_END.equals((Object)this.context.peek());
    }

    private static final boolean isURI(char[] chars, int offset, int length) {
        if (chars[offset] == '#') {
            return false;
        }
        try {
            return URI.create(String.valueOf(chars, offset, length)) != null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    static enum Context {
        DOCUMENT_BEGIN,
        DOCUMENT_END,
        BLOCK_SEQUENCE,
        BLOCK_MAPPING_KEY,
        BLOCK_MAPPING_VALUE;

    }
}

