/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.yaml.printer;

import com.apicatalog.yaml.printer.IndentedPrinter;
import java.io.IOException;

final class DoubleQuotedPrinter {
    private final IndentedPrinter printer;

    public DoubleQuotedPrinter(IndentedPrinter printer) {
        this.printer = printer;
    }

    public void printFolded(int maxLineLength, char[] chars, int offset, int length) throws IOException {
        int lineIndex = 0;
        int lastSpaceIndex = 0;
        boolean prevSpace = true;
        for (int i = 0; i < length; ++i) {
            boolean trailingSpace;
            if ('\n' == chars[i + offset]) {
                if (i - lineIndex > 0) {
                    this.doubleEscape(chars, offset + lineIndex, i - lineIndex - ((trailingSpace = DoubleQuotedPrinter.hasTrailingSpace(chars, offset + (lineIndex += this.printLeadingSpace(chars, offset + lineIndex)), i - lineIndex)) ? 1 : 0));
                    if (trailingSpace) {
                        this.printer.print(new char[]{'\\', ' '});
                    }
                }
                if (!this.printer.isNewLine()) {
                    this.printer.println();
                }
                this.printer.println();
                lineIndex = i + 1;
                lastSpaceIndex = i;
                prevSpace = false;
                continue;
            }
            if (i - lineIndex >= maxLineLength && lastSpaceIndex > lineIndex) {
                this.doubleEscape(chars, offset + lineIndex, lastSpaceIndex - lineIndex - 1 - ((trailingSpace = DoubleQuotedPrinter.hasTrailingSpace(chars, offset + (lineIndex += this.printLeadingSpace(chars, offset + lineIndex)), lastSpaceIndex - lineIndex - 1)) ? 1 : 0));
                if (trailingSpace) {
                    this.printer.print(new char[]{'\\', ' '});
                }
                this.printer.println();
                lineIndex = lastSpaceIndex;
                prevSpace = false;
                continue;
            }
            if (' ' == chars[i + offset] && !prevSpace) {
                lastSpaceIndex = i + 1;
                prevSpace = true;
                continue;
            }
            prevSpace = false;
        }
        if (lineIndex < length) {
            lineIndex += this.printLeadingSpace(chars, offset + lineIndex);
            this.doubleEscape(chars, offset + lineIndex, length - lineIndex);
        }
    }

    public void printInline(char[] chars, int offset, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            this.doubleEscape(chars, offset + i, 1);
        }
    }

    private int printLeadingSpace(char[] chars, int offset) throws IOException {
        if (!this.printer.isNewLine() || ' ' != chars[offset]) {
            return 0;
        }
        this.printer.print(new char[]{'\\', ' '});
        return 1;
    }

    private static final boolean hasTrailingSpace(char[] chars, int offset, int length) {
        return chars[offset + length - 1] == ' ';
    }

    private void doubleEscape(char[] chars, int offset, int length) throws IOException {
        int start = 0;
        for (int i = 0; i < length; ++i) {
            char[] hex;
            char[] escaped = null;
            if (chars[offset + i] == '\\') {
                escaped = new char[]{'\\', '\\'};
            } else if (chars[offset + i] == '\u0000') {
                escaped = new char[]{'\\', '0'};
            } else if (chars[offset + i] == '\t') {
                escaped = new char[]{'\\', 't'};
            } else if (chars[offset + i] == '\n') {
                escaped = new char[]{'\\', 'n'};
            } else if (chars[offset + i] == '\r') {
                escaped = new char[]{'\\', 'r'};
            } else if (chars[offset + i] == '\u0007') {
                escaped = new char[]{'\\', 'a'};
            } else if (chars[offset + i] == '\b') {
                escaped = new char[]{'\\', 'b'};
            } else if (chars[offset + i] == '\u000b') {
                escaped = new char[]{'\\', 'v'};
            } else if (chars[offset + i] == '\f') {
                escaped = new char[]{'\\', 'f'};
            } else if (chars[offset + i] == '\u001b') {
                escaped = new char[]{'\\', 'e'};
            } else if (chars[offset + i] == '\"') {
                escaped = new char[]{'\\', '\"'};
            } else if (chars[offset + i] == '/') {
                escaped = new char[]{'\\', '/'};
            } else if (chars[offset + i] == '\u00a0') {
                escaped = new char[]{'\\', '_'};
            } else if (chars[offset + i] == '\u0085') {
                escaped = new char[]{'\\', 'N'};
            } else if (chars[offset + i] == '\u2028') {
                escaped = new char[]{'\\', 'L'};
            } else if (chars[offset + i] == '\u2029') {
                escaped = new char[]{'\\', 'P'};
            } else if (chars[offset + i] < ' ' || chars[offset + i] > '~' && chars[offset + i] < '\u00a0') {
                hex = Integer.toHexString(chars[offset + i] | 0x100).substring(1).toCharArray();
                escaped = new char[]{'\\', 'x', hex[0], hex[1]};
            } else {
                if ((chars[offset + i] <= '\ud7ff' || chars[offset + i] >= '\ue000') && (chars[offset + i] <= '\ufffd' || chars[offset + i] >= '\u10000')) continue;
                hex = Integer.toHexString(chars[offset + i] | 0x10000).substring(1).toCharArray();
                escaped = new char[]{'\\', 'u', hex[0], hex[1], hex[2], hex[3]};
            }
            if (escaped == null) continue;
            if (i > start) {
                this.printer.print(chars, offset + start, i - start);
            }
            this.printer.print(escaped);
            start = i + 1;
        }
        if (length > start) {
            this.printer.print(chars, offset + start, length - start);
        }
    }
}

