/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.yaml.printer;

import com.apicatalog.yaml.printer.IndentedPrinter;
import java.io.IOException;

final class FoldedPrinter {
    private final IndentedPrinter printer;

    public FoldedPrinter(IndentedPrinter printer) {
        this.printer = printer;
    }

    public void print(int maxLineLength, char[] chars, int offset, int length) throws IOException {
        Context context = Context.LINE;
        int lineIndex = 0;
        int lastSpaceIndex = 0;
        for (int i = 0; i < length; ++i) {
            char ch = chars[i + offset];
            if (Context.LINE.equals((Object)context)) {
                if ('\n' == ch) {
                    if (i - lineIndex > 0) {
                        this.printer.print(chars, offset + lineIndex, i - lineIndex);
                        this.printer.println();
                    }
                    if (i + 1 < length && chars[i + offset + 1] == ' ') {
                        context = Context.INDENTED;
                    } else {
                        this.printer.println();
                    }
                    lineIndex = i + 1;
                    lastSpaceIndex = i;
                    continue;
                }
                if (' ' == ch) {
                    lastSpaceIndex = i;
                    continue;
                }
                if (i - lineIndex < maxLineLength || lastSpaceIndex <= lineIndex) continue;
                this.printer.print(chars, offset + lineIndex, lastSpaceIndex - lineIndex);
                this.printer.println();
                lineIndex = lastSpaceIndex + 1;
                continue;
            }
            if (!Context.INDENTED.equals((Object)context) || '\n' != ch) continue;
            if (i - lineIndex > 0) {
                this.printer.print(chars, offset + lineIndex, i - lineIndex);
            }
            this.printer.println();
            if (i + 1 >= length || chars[i + offset + 1] != ' ' && chars[i + offset + 1] != '\n') {
                context = Context.LINE;
            }
            lineIndex = i + 1;
            lastSpaceIndex = i;
        }
        if (lineIndex < length) {
            this.printer.print(chars, offset + lineIndex, length - lineIndex);
        }
    }

    static enum Context {
        LINE,
        INDENTED;

    }
}

