/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.yaml.printer;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Deque;

final class IndentedPrinter
implements Closeable {
    private final Writer writer;
    private boolean newLine;
    private int printed;
    private static final char[] SPACES = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private Deque<Integer> indentation;

    public IndentedPrinter(Writer writer) {
        this.writer = writer;
        this.indentation = new ArrayDeque<Integer>(30);
        this.indentation.push(0);
        this.newLine = false;
        this.printed = 0;
    }

    public IndentedPrinter beginBlock() {
        this.indentation.push(this.indentation.peek() + 2);
        return this;
    }

    public IndentedPrinter endBlock() {
        this.indentation.pop();
        this.newLine = true;
        return this;
    }

    public IndentedPrinter beginFlow() {
        this.indentation.push(this.newLine ? this.indentation.peek() : this.printed);
        return this;
    }

    public IndentedPrinter endFlow() {
        this.indentation.pop();
        return this;
    }

    public IndentedPrinter println() throws IOException {
        if (this.newLine) {
            this.writer.write(new char[]{'\n'});
            this.printed = 0;
            return this;
        }
        this.newLine = true;
        return this;
    }

    public IndentedPrinter print(char[] chars) throws IOException {
        return this.print(chars, 0, chars.length);
    }

    public IndentedPrinter print(char[] chars, int offset, int length) throws IOException {
        if (this.newLine) {
            this.printIndentation();
        }
        this.printed += length;
        this.writer.write(chars, offset, length);
        return this;
    }

    public IndentedPrinter print(char ch) throws IOException {
        return this.print(new char[]{ch}, 0, 1);
    }

    private final void printIndentation() throws IOException {
        int spaces;
        this.writer.write(new char[]{'\n'});
        this.printed = this.indentation.peek();
        this.newLine = false;
        if (spaces > 0) {
            for (spaces = this.indentation.peek().intValue(); spaces >= SPACES.length; spaces -= SPACES.length) {
                this.writer.write(SPACES, 0, SPACES.length);
            }
            if (spaces > 0) {
                this.writer.write(SPACES, 0, spaces);
            }
        }
    }

    public int indentation() {
        return this.indentation.peek();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public boolean isNewLine() {
        return this.newLine;
    }
}

