/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.yaml.printer;

import com.apicatalog.yaml.printer.IndentedPrinter;
import java.io.IOException;

final class SingleQuotedPrinter {
    private final IndentedPrinter printer;

    public SingleQuotedPrinter(IndentedPrinter printer) {
        this.printer = printer;
    }

    public void print(int maxLineLength, char[] chars, int offset, int length) throws IOException {
        int lineIndex = 0;
        int lastSpaceIndex = 0;
        for (int i = 0; i < length; ++i) {
            if ('\n' == chars[i + offset]) {
                if (i - lineIndex > 0) {
                    this.singleEscape(chars, offset + lineIndex, i - lineIndex);
                }
                this.printer.println();
                this.printer.println();
                lineIndex = i + 1;
                lastSpaceIndex = i + 1;
                continue;
            }
            if (' ' == chars[i + offset]) {
                lastSpaceIndex = i + 1;
                continue;
            }
            if (i - lineIndex < maxLineLength) continue;
            this.singleEscape(chars, offset + lineIndex, lastSpaceIndex - lineIndex - 1);
            this.printer.println();
            lineIndex = lastSpaceIndex;
        }
        if (lineIndex < length) {
            this.singleEscape(chars, offset + lineIndex, length - lineIndex);
        }
    }

    private void singleEscape(char[] chars, int offset, int length) throws IOException {
        int start = 0;
        for (int i = 0; i < length; ++i) {
            if (chars[offset + i] != '\'') continue;
            if (i >= start) {
                this.printer.print(chars, offset + start, i - start + 1);
            }
            this.printer.print('\'');
            start = i + 1;
        }
        if (length > start) {
            this.printer.print(chars, offset + start, length - start);
        }
    }
}

