/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.yaml.provider;

import com.apicatalog.yaml.node.YamlMapping;
import com.apicatalog.yaml.node.YamlNode;
import com.apicatalog.yaml.node.builder.YamlMappingBuilder;
import com.apicatalog.yaml.node.builder.YamlSequenceBuilder;
import com.apicatalog.yaml.provider.YamlMappingImpl;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

final class YamlMappingBuilderImpl
implements YamlMappingBuilder {
    private final Map<String, YamlNode> mapping;

    public YamlMappingBuilderImpl() {
        this(new LinkedHashMap<String, YamlNode>());
    }

    protected YamlMappingBuilderImpl(Map<String, YamlNode> mapping) {
        this.mapping = mapping;
    }

    public static final YamlMappingBuilder of(Map<String, YamlNode> mapping) {
        return new YamlMappingBuilderImpl(new LinkedHashMap<String, YamlNode>(mapping));
    }

    @Override
    public YamlMappingBuilder add(String key, YamlNode value) {
        this.mapping.put(key, value);
        return this;
    }

    @Override
    public YamlMappingBuilder add(String key, YamlMappingBuilder value) {
        this.mapping.put(key, value.build());
        return this;
    }

    @Override
    public YamlMappingBuilder add(String key, YamlSequenceBuilder value) {
        this.mapping.put(key, value.build());
        return this;
    }

    @Override
    public YamlMapping build() {
        if (this.mapping == null || this.mapping.isEmpty()) {
            return new YamlMappingImpl(Collections.emptyMap());
        }
        return new YamlMappingImpl(Collections.unmodifiableMap(this.mapping));
    }
}

