/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.yaml.provider;

import com.apicatalog.yaml.node.YamlNode;
import com.apicatalog.yaml.node.YamlSequence;
import com.apicatalog.yaml.node.builder.YamlMappingBuilder;
import com.apicatalog.yaml.node.builder.YamlSequenceBuilder;
import com.apicatalog.yaml.provider.YamlSequenceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class YamlSequenceBuilderImpl
implements YamlSequenceBuilder {
    private final ArrayList<YamlNode> items;

    public YamlSequenceBuilderImpl() {
        this(new ArrayList<YamlNode>());
    }

    protected YamlSequenceBuilderImpl(ArrayList<YamlNode> nodes) {
        this.items = nodes;
    }

    public static final YamlSequenceBuilder of(List<YamlNode> nodes) {
        return new YamlSequenceBuilderImpl(new ArrayList<YamlNode>(nodes));
    }

    @Override
    public YamlSequenceBuilder add(YamlNode node) {
        this.items.add(node);
        return this;
    }

    @Override
    public YamlSequenceBuilder addNull() {
        this.items.add(YamlNode.NULL);
        return this;
    }

    @Override
    public YamlSequenceBuilder add(YamlMappingBuilder builder) {
        this.items.add(builder.build());
        return this;
    }

    @Override
    public YamlSequenceBuilder add(YamlSequenceBuilder builder) {
        this.items.add(builder.build());
        return this;
    }

    @Override
    public YamlSequence build() {
        if (this.items == null || this.items.isEmpty()) {
            return new YamlSequenceImpl(Collections.emptyList());
        }
        return new YamlSequenceImpl(Collections.unmodifiableList(this.items));
    }
}

