/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.yaml.provider;

import com.apicatalog.yaml.printer.DefaultYamlPrinter;
import com.apicatalog.yaml.writer.DefaultYamlWriter;
import com.apicatalog.yaml.writer.YamlPrintStyle;
import com.apicatalog.yaml.writer.YamlWriter;
import com.apicatalog.yaml.writer.YamlWriterBuilder;
import java.io.Writer;

final class YamlWriterBuilderImpl
implements YamlWriterBuilder {
    private final YamlPrintStyle style;
    private final Writer writer;

    public YamlWriterBuilderImpl(Writer writer) {
        this.writer = writer;
        this.style = new YamlPrintStyle();
    }

    @Override
    public YamlWriterBuilder maxLineWidth(int maxLineWidth) {
        this.style.setMaxLineWidth(maxLineWidth);
        return this;
    }

    @Override
    public YamlWriter build() {
        return YamlWriterBuilderImpl.build(this.writer, this.style);
    }

    public static final YamlWriter build(Writer writer, YamlPrintStyle style) {
        return new DefaultYamlWriter(new DefaultYamlPrinter(writer, style));
    }

    @Override
    public YamlWriterBuilder compactArrays(boolean enable) {
        this.style.setCompactArrays(enable);
        return this;
    }
}

