/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.yaml.writer;

import com.apicatalog.yaml.YamlException;
import com.apicatalog.yaml.node.YamlNode;
import com.apicatalog.yaml.printer.YamlPrinter;
import com.apicatalog.yaml.writer.YamlWriter;
import java.io.IOException;
import java.util.Map;

public class DefaultYamlWriter
implements YamlWriter {
    private final YamlPrinter printer;

    public DefaultYamlWriter(YamlPrinter printer) {
        this.printer = printer;
    }

    @Override
    public void write(YamlNode node) throws YamlException, IOException {
        switch (node.getNodeType()) {
            case MAPPING: {
                this.printer.beginBlockMapping();
                for (Map.Entry entry : node.asMapping().entrySet()) {
                    this.writeScalar((String)entry.getKey());
                    this.write((YamlNode)entry.getValue());
                }
                this.printer.endBlockdMapping();
                break;
            }
            case NULL: {
                this.printer.printNull();
                break;
            }
            case SCALAR: {
                this.writeScalar(node.asScalar().getValue());
                break;
            }
            case SEQUENCE: {
                this.printer.beginBlockSequence();
                for (YamlNode item : node.asSequence()) {
                    this.write(item);
                }
                this.printer.endBlockSequence();
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.printer.close();
    }

    private final void writeScalar(String scalar) throws IOException {
        char[] value = scalar.toCharArray();
        this.printer.printScalar(value, 0, value.length);
    }
}

