/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.ld;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.ld.Term;
import java.util.Arrays;

public class DocumentError
extends Throwable {
    private static final long serialVersionUID = -7146533158378348477L;
    private final ErrorType type;
    private final String code;

    public DocumentError(ErrorType type, String code) {
        this.type = type;
        this.code = type.name().concat(code);
    }

    public DocumentError(Throwable e, ErrorType type, String code) {
        super(e);
        this.type = type;
        this.code = type.name().concat(code);
    }

    public DocumentError(ErrorType type, Term ... terms) {
        this.type = type;
        this.code = DocumentError.toCode(type, terms);
    }

    public DocumentError(Throwable e, ErrorType type, Term ... terms) {
        super(e);
        this.type = type;
        this.code = DocumentError.toCode(type, terms);
    }

    public ErrorType getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.getCode();
    }

    public String getCode() {
        return this.code;
    }

    public static void failWithJsonLd(JsonLdError e) throws DocumentError {
        if (JsonLdErrorCode.LOADING_DOCUMENT_FAILED == e.getCode()) {
            throw new DocumentError((Throwable)e, ErrorType.Invalid, new Term[0]);
        }
        if (JsonLdErrorCode.LOADING_REMOTE_CONTEXT_FAILED == e.getCode()) {
            throw new DocumentError((Throwable)e, ErrorType.Invalid, new Term[0]);
        }
    }

    static final String toCode(ErrorType type, Term ... terms) {
        StringBuilder sb = new StringBuilder();
        if (type != null) {
            sb.append(type.name());
        }
        if (terms == null || terms.length == 0) {
            return sb.append("Document").toString();
        }
        Arrays.stream(terms).forEach(term -> {
            int index = term.name().startsWith("@") ? 1 : 0;
            sb.append(Character.toUpperCase(term.name().charAt(index)));
            sb.append(term.name().substring(index + 1));
        });
        return sb.toString();
    }

    public static enum ErrorType {
        Missing,
        Unknown,
        Invalid;

    }
}

