/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.ld.node;

import com.apicatalog.jsonld.StringUtils;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.Term;
import com.apicatalog.ld.node.LdNodeImpl;
import com.apicatalog.ld.node.LdScalar;
import com.apicatalog.ld.node.LdType;
import com.apicatalog.ld.node.adapter.LdAdapter;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.net.URI;

public interface LdNode {
    public static final LdNode NULL = new LdNode(){

        @Override
        public LdType type() {
            return null;
        }

        @Override
        public LdScalar scalar(Term term) throws DocumentError {
            return LdScalar.NULL;
        }

        @Override
        public LdNode node(Term term) throws DocumentError {
            return NULL;
        }

        @Override
        public <T> T map(LdAdapter<T> adapter) throws DocumentError {
            return null;
        }

        @Override
        public URI id() throws DocumentError {
            return null;
        }
    };

    public static LdNode of(JsonObject object) {
        return LdNodeImpl.of(object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isTypeOf(String type, JsonValue value) {
        if (StringUtils.isBlank((String)type)) {
            throw new IllegalArgumentException("The 'type' parameter must not be null nor blank.");
        }
        if (value == null) {
            throw new IllegalArgumentException("The 'object' parameter must not be null.");
        }
        if (!JsonUtils.isObject((JsonValue)value)) return false;
        if (!value.asJsonObject().containsKey((Object)"@type")) return false;
        if (!JsonUtils.toStream((JsonValue)((JsonValue)value.asJsonObject().get((Object)"@type"))).filter(JsonUtils::isString).map(JsonString.class::cast).map(JsonString::getString).filter(StringUtils::isNotBlank).anyMatch(type::equals)) return false;
        return true;
    }

    public static boolean hasType(JsonValue expanded) {
        if (expanded == null) {
            throw new IllegalArgumentException("The 'expanded' parameter must not be null.");
        }
        return JsonUtils.isObject((JsonValue)expanded) && expanded.asJsonObject().containsKey((Object)"@type");
    }

    public URI id() throws DocumentError;

    public LdType type();

    public LdScalar scalar(Term var1) throws DocumentError;

    public LdNode node(Term var1) throws DocumentError;

    default public boolean exists() {
        return false;
    }

    public <T> T map(LdAdapter<T> var1) throws DocumentError;
}

