/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.ld.node;

import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.ValueObject;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.Term;
import com.apicatalog.ld.node.LdNode;
import com.apicatalog.ld.node.LdScalar;
import com.apicatalog.ld.node.LdScalarImpl;
import com.apicatalog.ld.node.LdType;
import com.apicatalog.ld.node.adapter.LdAdapter;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.net.URI;

class LdNodeImpl
implements LdNode {
    final JsonObject object;

    protected LdNodeImpl(JsonObject object) {
        this.object = object;
    }

    public static LdNode of(JsonObject object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        return new LdNodeImpl(object);
    }

    @Override
    public URI id() throws DocumentError {
        JsonValue id = (JsonValue)this.object.get((Object)"@id");
        if (JsonUtils.isString((JsonValue)id)) {
            try {
                return URI.create(((JsonString)id).getString());
            }
            catch (IllegalArgumentException e) {
                throw new DocumentError(DocumentError.ErrorType.Invalid, "@id");
            }
        }
        if (JsonUtils.isNotNull((JsonValue)id)) {
            throw new DocumentError(DocumentError.ErrorType.Invalid, "@id");
        }
        return null;
    }

    @Override
    public LdScalar scalar(Term term) throws DocumentError {
        JsonValue values = (JsonValue)this.object.get((Object)term.uri());
        if (JsonUtils.isArray((JsonValue)values)) {
            JsonArray expanded = values.asJsonArray();
            if (expanded.isEmpty()) {
                return LdScalar.NULL;
            }
            if (expanded.size() > 1) {
                throw new DocumentError(DocumentError.ErrorType.Invalid, term);
            }
            JsonValue value = (JsonValue)expanded.iterator().next();
            if (JsonUtils.isNotObject((JsonValue)value) || !ValueObject.isValueObject((JsonValue)value)) {
                throw new DocumentError(DocumentError.ErrorType.Invalid, term);
            }
            return LdScalarImpl.of(term, value.asJsonObject());
        }
        if (JsonUtils.isNotNull((JsonValue)values)) {
            throw new DocumentError(DocumentError.ErrorType.Invalid, term);
        }
        return LdScalar.NULL;
    }

    @Override
    public LdNode node(Term term) throws DocumentError {
        JsonValue values = (JsonValue)this.object.get((Object)term.uri());
        if (JsonUtils.isArray((JsonValue)values)) {
            JsonArray expanded = values.asJsonArray();
            if (expanded.isEmpty()) {
                return LdNode.NULL;
            }
            if (expanded.size() > 1) {
                throw new DocumentError(DocumentError.ErrorType.Invalid, term);
            }
            JsonValue value = (JsonValue)expanded.iterator().next();
            if (JsonUtils.isNotObject((JsonValue)value) || ValueObject.isValueObject((JsonValue)value)) {
                throw new DocumentError(DocumentError.ErrorType.Invalid, term);
            }
            return LdNodeImpl.of(value.asJsonObject());
        }
        if (JsonUtils.isNotNull((JsonValue)values)) {
            throw new DocumentError(DocumentError.ErrorType.Invalid, term);
        }
        return LdNode.NULL;
    }

    @Override
    public <T> T map(LdAdapter<T> adapter) throws DocumentError {
        return adapter.read(this.object);
    }

    @Override
    public LdType type() {
        return new LdType(this.object);
    }

    @Override
    public boolean exists() {
        return true;
    }
}

