/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.ld.node;

import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.Term;
import com.apicatalog.ld.node.LdScalar;
import com.apicatalog.ld.node.adapter.XsdDateTimeAdapter;
import com.apicatalog.multibase.Multibase;
import com.apicatalog.multicodec.Multicodec;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.net.URI;
import java.time.Instant;

class LdScalarImpl
implements LdScalar {
    final Term term;
    final String type;
    final JsonValue value;

    protected LdScalarImpl(Term term, String type, JsonValue value) {
        this.term = term;
        this.type = type;
        this.value = value;
    }

    public static LdScalar of(Term term, JsonObject object) throws DocumentError {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        JsonValue value = (JsonValue)object.get((Object)"@value");
        JsonValue type = (JsonValue)object.get((Object)"@type");
        if (JsonUtils.isNull((JsonValue)type)) {
            return new LdScalarImpl(term, null, value);
        }
        if (JsonUtils.isString((JsonValue)type)) {
            return new LdScalarImpl(term, ((JsonString)type).getString(), value);
        }
        throw new DocumentError(DocumentError.ErrorType.Invalid, term);
    }

    @Override
    public URI link() throws DocumentError {
        String link = this.string();
        try {
            return link != null ? URI.create(link) : null;
        }
        catch (IllegalArgumentException e) {
            throw new DocumentError((Throwable)e, DocumentError.ErrorType.Invalid, this.term);
        }
    }

    @Override
    public String string() throws DocumentError {
        if (JsonUtils.isString((JsonValue)this.value)) {
            return ((JsonString)this.value).getString();
        }
        if (JsonUtils.isNotNull((JsonValue)this.value)) {
            throw new DocumentError(DocumentError.ErrorType.Invalid, this.term);
        }
        return null;
    }

    @Override
    public String string(String expectedType) throws DocumentError {
        if (!this.type.equals(expectedType)) {
            throw new DocumentError(DocumentError.ErrorType.Invalid, this.type);
        }
        return this.string();
    }

    @Override
    public boolean exists() {
        return JsonUtils.isNotNull((JsonValue)this.value);
    }

    @Override
    public byte[] multibase(Multibase base) throws DocumentError {
        if (!"https://w3id.org/security#multibase".equals(this.type)) {
            throw new DocumentError(DocumentError.ErrorType.Invalid, this.term);
        }
        String string = this.string();
        if (string != null) {
            try {
                return base.decode(string);
            }
            catch (IllegalArgumentException e) {
                throw new DocumentError((Throwable)e, DocumentError.ErrorType.Invalid, this.term);
            }
        }
        return null;
    }

    @Override
    public byte[] multiformat(Multibase base, Multicodec codec) throws DocumentError {
        if (!"https://w3id.org/security#multibase".equals(this.type)) {
            throw new DocumentError(DocumentError.ErrorType.Invalid, this.term);
        }
        String string = this.string();
        if (string != null) {
            try {
                byte[] debased = base.decode(string);
                if (debased != null && debased.length > 0) {
                    return codec.decode(debased);
                }
            }
            catch (IllegalArgumentException e) {
                throw new DocumentError((Throwable)e, DocumentError.ErrorType.Invalid, this.term);
            }
        }
        return null;
    }

    @Override
    public Instant xsdDateTime() throws DocumentError {
        if (!"http://www.w3.org/2001/XMLSchema#dateTime".equals(this.type)) {
            throw new DocumentError(DocumentError.ErrorType.Invalid, this.term);
        }
        String string = this.string();
        if (string != null) {
            try {
                return XsdDateTimeAdapter.read(string);
            }
            catch (IllegalArgumentException e) {
                throw new DocumentError((Throwable)e, DocumentError.ErrorType.Invalid, this.term);
            }
        }
        return null;
    }

    @Override
    public String type() throws DocumentError {
        return this.type;
    }

    @Override
    public JsonValue value() throws DocumentError {
        return this.value;
    }

    @Override
    public JsonValue value(String expectedType) throws DocumentError {
        if (!this.type.equals(expectedType)) {
            throw new DocumentError(DocumentError.ErrorType.Invalid, this.type);
        }
        return this.value;
    }
}

