/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.ld.node;

import com.apicatalog.ld.Term;
import com.apicatalog.ld.node.LdNodeBuilder;
import com.apicatalog.ld.node.adapter.LdAdapter;
import com.apicatalog.multibase.Multibase;
import com.apicatalog.vc.VcVocab;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.net.URI;
import java.time.Instant;

public class LdSetter {
    final LdNodeBuilder parent;
    final Term term;
    final JsonObjectBuilder builder;
    final JsonArray content;

    protected LdSetter(LdNodeBuilder parent, Term term, JsonObjectBuilder builder, JsonArray content) {
        this.parent = parent;
        this.term = term;
        this.builder = builder;
        this.content = content;
    }

    public LdNodeBuilder link(URI uri) {
        this.string(uri.toString());
        return this.parent;
    }

    public LdNodeBuilder string(String value) {
        this.scalar(null, value);
        return this.parent;
    }

    public LdNodeBuilder scalar(String type, String value) {
        JsonObjectBuilder scalar = Json.createObjectBuilder();
        if (type != null) {
            scalar.add("@type", type);
        }
        scalar.add("@value", value);
        this.value((JsonValue)scalar.build());
        return this.parent;
    }

    public LdNodeBuilder value(JsonValue value) {
        this.builder.add(this.term.uri(), (JsonValue)this.setOrAdd(value));
        return this.parent;
    }

    public <T> LdNodeBuilder map(LdAdapter<T> adapter, T value) {
        if (value != null) {
            this.value((JsonValue)adapter.write(value));
        }
        return this.parent;
    }

    public LdNodeBuilder xsdDateTime(Instant created) {
        this.scalar(VcVocab.XSD_DATETIME.uri(), created.toString());
        return this.parent;
    }

    public LdNodeBuilder multibase(Multibase base, byte[] value) {
        this.scalar(VcVocab.MULTIBASE_TYPE.uri(), base.encode(value));
        return this.parent;
    }

    public LdNodeBuilder id(URI id) {
        if (id != null) {
            JsonObjectBuilder node = Json.createObjectBuilder();
            node.add("@id", (JsonValue)Json.createValue((String)id.toString()));
            this.value((JsonValue)node.build());
        }
        return this.parent;
    }

    JsonArray setOrAdd(JsonValue value) {
        if (this.content != null) {
            return Json.createArrayBuilder((JsonArray)this.content).add(value).build();
        }
        return Json.createArrayBuilder().add(value).build();
    }
}

