/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.ld.node;

import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.Term;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class LdType {
    final JsonObject object;

    public LdType(JsonObject object) {
        this.object = object;
    }

    public URI link() throws DocumentError {
        String link = this.string();
        return link != null ? URI.create(link) : null;
    }

    public Collection<String> strings() throws DocumentError {
        return LdType.strings(this.object);
    }

    public static Collection<String> strings(JsonObject object) throws DocumentError {
        JsonValue types = (JsonValue)object.get((Object)"@type");
        if (JsonUtils.isNonEmptyArray((JsonValue)types)) {
            ArrayList<String> strings = new ArrayList<String>(types.asJsonArray().size());
            for (JsonValue type : types.asJsonArray()) {
                if (JsonUtils.isNotString((JsonValue)type)) {
                    throw new DocumentError(DocumentError.ErrorType.Invalid, "@type");
                }
                strings.add(((JsonString)type).getString());
            }
            return strings;
        }
        return Collections.emptyList();
    }

    public String string() throws DocumentError {
        JsonValue type = (JsonValue)this.object.get((Object)"@type");
        if (JsonUtils.isNotNull((JsonValue)type)) {
            Collection types = JsonUtils.toCollection((JsonValue)type);
            if (types.size() > 1) {
                throw new DocumentError(DocumentError.ErrorType.Invalid, "@type");
            }
            if (types.size() > 0) {
                type = (JsonValue)types.iterator().next();
            }
        }
        if (JsonUtils.isNull((JsonValue)type)) {
            return null;
        }
        if (JsonUtils.isString((JsonValue)type)) {
            return ((JsonString)type).getString();
        }
        throw new DocumentError(DocumentError.ErrorType.Invalid, "@type");
    }

    public boolean exists() {
        return this.object != null && JsonUtils.isNotNull((JsonValue)((JsonValue)this.object.get((Object)"@type")));
    }

    public boolean hasType(Term type) {
        return this.hasType(type.uri());
    }

    public boolean hasType(String type) {
        if (JsonUtils.isNull((JsonValue)this.object)) {
            return false;
        }
        JsonValue types = (JsonValue)this.object.get((Object)"@type");
        return JsonUtils.isNotNull((JsonValue)types) && JsonUtils.toStream((JsonValue)types).filter(JsonUtils::isString).map(t -> ((JsonString)t).getString()).anyMatch(t -> type.equals(t));
    }
}

