/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.ld.signature;

import com.apicatalog.ld.signature.CryptoSuite;
import com.apicatalog.ld.signature.LinkedDataSuiteError;
import com.apicatalog.ld.signature.SigningError;
import com.apicatalog.ld.signature.VerificationError;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import java.util.Objects;

public class LinkedDataSignature {
    private final CryptoSuite suite;

    public LinkedDataSignature(CryptoSuite suite) {
        this.suite = suite;
    }

    public void verify(JsonObject expanded, JsonObject unsignedProof, byte[] verificationKey, byte[] signature) throws VerificationError {
        Objects.requireNonNull(expanded);
        Objects.requireNonNull(unsignedProof);
        Objects.requireNonNull(verificationKey);
        Objects.requireNonNull(signature);
        try {
            byte[] computeSignature = this.hashCode((JsonStructure)expanded, unsignedProof);
            this.suite.verify(verificationKey, signature, computeSignature);
        }
        catch (LinkedDataSuiteError e) {
            throw new VerificationError(VerificationError.Code.InvalidSignature, (Throwable)e);
        }
    }

    public byte[] sign(JsonObject expanded, byte[] privateKey, JsonObject proof) throws SigningError {
        Objects.requireNonNull(expanded);
        Objects.requireNonNull(privateKey);
        Objects.requireNonNull(proof);
        try {
            byte[] documentHashCode = this.hashCode((JsonStructure)expanded, proof);
            return this.suite.sign(privateKey, documentHashCode);
        }
        catch (LinkedDataSuiteError e) {
            throw new SigningError(SigningError.Code.Internal, (Throwable)e);
        }
    }

    byte[] hashCode(JsonStructure document, JsonObject proof) throws LinkedDataSuiteError {
        byte[] proofHash = this.suite.digest(this.suite.canonicalize((JsonStructure)proof));
        byte[] documentHash = this.suite.digest(this.suite.canonicalize(document));
        byte[] result = new byte[proofHash.length + documentHash.length];
        System.arraycopy(proofHash, 0, result, 0, proofHash.length);
        System.arraycopy(documentHash, 0, result, proofHash.length, documentHash.length);
        return result;
    }
}

