/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.ld.signature.sd;

import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.BlankNode;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonPointer;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class DocumentSelector {
    protected final Collection<JsonPointer> pointers;

    protected DocumentSelector(Collection<JsonPointer> pointers) {
        this.pointers = pointers;
    }

    public static DocumentSelector of(Collection<String> pointers) {
        return new DocumentSelector(DocumentSelector.toJsonPointers(pointers));
    }

    public Map<String, JsonValue> getValues(JsonObject document) {
        HashMap<String, JsonValue> map = new HashMap<String, JsonValue>();
        for (JsonPointer pointer : this.pointers) {
            map.put(pointer.toString(), pointer.getValue((JsonStructure)document));
        }
        return map;
    }

    public JsonObject getNodes(JsonObject document) {
        if (this.pointers == null || this.pointers.isEmpty()) {
            return JsonValue.EMPTY_JSON_OBJECT;
        }
        JsonObject root = null;
        for (JsonPointer pointer : this.pointers) {
            root = DocumentSelector.createNode(root, document, pointer.toString().split("\\/"), 1);
        }
        JsonObjectBuilder builder = Json.createObjectBuilder(root);
        for (Map.Entry entry : root.entrySet()) {
            JsonValue value = DocumentSelector.denseArrays((JsonValue)entry.getValue());
            if (!JsonUtils.isNotNull((JsonValue)value)) continue;
            builder.add((String)entry.getKey(), value);
        }
        return builder.build();
    }

    static Collection<JsonPointer> toJsonPointers(Collection<String> pointers) {
        if (pointers == null) {
            return Collections.emptyList();
        }
        return pointers.stream().sorted(Collections.reverseOrder()).map(Json::createPointer).collect(Collectors.toList());
    }

    private static JsonObject createNode(JsonObject target, JsonObject source, String[] segments, int index) {
        if (index == segments.length) {
            return source;
        }
        JsonObjectBuilder node = JsonUtils.isNull((JsonValue)target) ? DocumentSelector.createNewNode(source) : Json.createObjectBuilder((JsonObject)target);
        JsonValue value = (JsonValue)source.get((Object)segments[index]);
        if (JsonUtils.isNull((JsonValue)value)) {
            throw new IllegalArgumentException();
        }
        if (JsonUtils.isScalar((JsonValue)value)) {
            node.add(segments[index], value);
        } else if (JsonUtils.isObject((JsonValue)value)) {
            node.add(segments[index], (JsonValue)DocumentSelector.createNode(JsonUtils.isNotNull((JsonValue)target) ? target.getJsonObject(segments[index]) : null, value.asJsonObject(), segments, index + 1));
        } else if (JsonUtils.isArray((JsonValue)value)) {
            node.add(segments[index], (JsonValue)DocumentSelector.createArray(JsonUtils.isNotNull((JsonValue)target) ? target.getJsonArray(segments[index]) : null, value.asJsonArray(), segments, index + 1));
        }
        return node.build();
    }

    private static JsonArray createArray(JsonArray target, JsonArray source, String[] segments, int index) {
        JsonValue value;
        JsonArrayBuilder array;
        if (index == segments.length) {
            return source;
        }
        int arrayIndex = Integer.parseInt(segments[index]);
        if (JsonUtils.isNull((JsonValue)target)) {
            array = Json.createArrayBuilder();
            for (i = 0; i <= arrayIndex; ++i) {
                array.add(JsonValue.NULL);
            }
        } else {
            array = Json.createArrayBuilder((JsonArray)target);
            if (arrayIndex >= target.size()) {
                for (i = target.size(); i <= arrayIndex; ++i) {
                    array.add(JsonValue.NULL);
                }
            }
        }
        if (JsonUtils.isNull((JsonValue)(value = (JsonValue)source.get(arrayIndex)))) {
            throw new IllegalArgumentException();
        }
        if (JsonUtils.isScalar((JsonValue)value)) {
            array.set(arrayIndex, value);
        } else if (JsonUtils.isObject((JsonValue)value)) {
            array.set(arrayIndex, (JsonValue)DocumentSelector.createNode(DocumentSelector.getNode(target, arrayIndex), value.asJsonObject(), segments, index + 1));
        } else if (JsonUtils.isArray((JsonValue)value)) {
            array.set(arrayIndex, (JsonValue)DocumentSelector.createArray(DocumentSelector.getArray(target, arrayIndex), value.asJsonArray(), segments, index + 1));
        }
        return array.build();
    }

    private static JsonArray getArray(JsonArray source, int index) {
        JsonValue value;
        JsonValue jsonValue = value = source != null ? (JsonValue)source.get(index) : null;
        if (JsonUtils.isNull((JsonValue)value)) {
            return null;
        }
        return value.asJsonArray();
    }

    private static JsonObject getNode(JsonArray source, int index) {
        JsonValue value;
        JsonValue jsonValue = value = source != null ? (JsonValue)source.get(index) : null;
        if (JsonUtils.isNull((JsonValue)value)) {
            return null;
        }
        return value.asJsonObject();
    }

    private static JsonValue denseArrays(JsonValue input) {
        if (JsonUtils.isArray((JsonValue)input)) {
            JsonArrayBuilder builder = Json.createArrayBuilder();
            for (JsonValue item : input.asJsonArray()) {
                JsonValue value = DocumentSelector.denseArrays(item);
                if (!JsonUtils.isNotNull((JsonValue)value)) continue;
                builder.add(value);
            }
            return builder.build();
        }
        if (JsonUtils.isObject((JsonValue)input)) {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            for (Map.Entry entry : input.asJsonObject().entrySet()) {
                builder.add((String)entry.getKey(), DocumentSelector.denseArrays((JsonValue)entry.getValue()));
            }
            return builder.build();
        }
        return input;
    }

    private static JsonObjectBuilder createNewNode(JsonObject source) {
        JsonValue type;
        JsonObjectBuilder selection = Json.createObjectBuilder();
        JsonValue id = (JsonValue)source.get((Object)"id");
        if (JsonUtils.isString((JsonValue)id) && !BlankNode.hasPrefix((String)((JsonString)id).getString())) {
            selection.add("id", id);
        }
        if (JsonUtils.isNotNull((JsonValue)(type = (JsonValue)source.get((Object)"type")))) {
            selection.add("type", type);
        }
        return selection;
    }
}

