/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.multikey;

import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.Term;
import com.apicatalog.ld.node.LdNode;
import com.apicatalog.ld.node.LdNodeBuilder;
import com.apicatalog.ld.node.LdScalar;
import com.apicatalog.ld.signature.VerificationMethod;
import com.apicatalog.ld.signature.key.KeyPair;
import com.apicatalog.ld.signature.key.VerificationKey;
import com.apicatalog.multibase.Multibase;
import com.apicatalog.multicodec.Multicodec;
import com.apicatalog.multicodec.MulticodecDecoder;
import com.apicatalog.multikey.MultiKey;
import com.apicatalog.vc.method.MethodAdapter;
import jakarta.json.JsonObject;

public abstract class MultiKeyAdapter
implements MethodAdapter {
    public static final Term CONTROLLER = Term.create("controller", "https://w3id.org/security#");
    public static final Term PUBLIC_KEY = Term.create("publicKeyMultibase", "https://w3id.org/security#");
    public static final Term PRIVATE_KEY = Term.create("secretKeyMultibase", "https://w3id.org/security#");
    public static final Term EXPIRATION = Term.create("expiration", "https://w3id.org/security#");
    public static final Term REVOKED = Term.create("revoked", "https://w3id.org/security#");
    protected final MulticodecDecoder decoder;

    public MultiKeyAdapter(MulticodecDecoder decoder) {
        this.decoder = decoder;
    }

    protected abstract Multicodec getPublicKeyCodec(String var1, int var2);

    protected abstract Multicodec getPrivateKeyCodec(String var1, int var2);

    protected void validate(MultiKey method) throws DocumentError {
    }

    @Override
    public VerificationMethod read(JsonObject document) throws DocumentError {
        if (document == null) {
            throw new IllegalArgumentException("Verification method cannot be null.");
        }
        LdNode node = LdNode.of(document);
        MultiKey multikey = new MultiKey();
        multikey.id = node.id();
        multikey.controller = node.node(CONTROLLER).id();
        if (node.type().hasType(MultiKey.TYPE.toString())) {
            multikey.publicKey = this.getKey(node, PUBLIC_KEY, multikey);
            multikey.privateKey = this.getKey(node, PRIVATE_KEY, multikey);
            multikey.expiration = node.scalar(EXPIRATION).xsdDateTime();
            multikey.revoked = node.scalar(REVOKED).xsdDateTime();
        } else if (node.type().exists()) {
            throw new DocumentError(DocumentError.ErrorType.Invalid, "VerificationMethodType");
        }
        this.validate(multikey);
        return multikey;
    }

    protected final byte[] getKey(LdNode node, Term term, MultiKey multikey) throws DocumentError {
        LdScalar key = node.scalar(term);
        if (key.exists()) {
            if (!"https://w3id.org/security#multibase".equals(key.type())) {
                throw new DocumentError(DocumentError.ErrorType.Invalid, term.name() + "Type");
            }
            String encodedKey = key.string();
            if (!Multibase.BASE_58_BTC.isEncoded(encodedKey)) {
                throw new DocumentError(DocumentError.ErrorType.Invalid, term.name() + "Type");
            }
            byte[] decodedKey = Multibase.BASE_58_BTC.decode(encodedKey);
            Multicodec codec = (Multicodec)this.decoder.getCodec(decodedKey).orElseThrow(() -> new DocumentError(DocumentError.ErrorType.Invalid, term.name() + "Codec"));
            if (multikey.algorithm == null) {
                multikey.algorithm = MultiKeyAdapter.getAlgorithmName(codec);
            } else if (!multikey.algorithm.equals(MultiKeyAdapter.getAlgorithmName(codec))) {
                throw new DocumentError(DocumentError.ErrorType.Invalid, "KeyPairCodec");
            }
            return codec.decode(decodedKey);
        }
        return null;
    }

    @Override
    public JsonObject write(VerificationMethod value) {
        KeyPair keyPair;
        VerificationKey verificationKey;
        LdNodeBuilder builder = new LdNodeBuilder();
        if (value.id() != null) {
            builder.id(value.id());
        }
        boolean embedded = false;
        if (value.controller() != null) {
            builder.set(CONTROLLER).id(value.controller());
            embedded = true;
        }
        if (value instanceof MultiKey) {
            MultiKey multikey = (MultiKey)value;
            if (multikey.getExpiration() != null) {
                builder.set(EXPIRATION).xsdDateTime(multikey.getExpiration());
                embedded = true;
            }
            if (multikey.getRevoked() != null) {
                builder.set(REVOKED).xsdDateTime(multikey.getRevoked());
                embedded = true;
            }
        }
        if (value instanceof VerificationKey && (verificationKey = (VerificationKey)value).publicKey() != null) {
            builder.set(PUBLIC_KEY).scalar("https://w3id.org/security#multibase", Multibase.BASE_58_BTC.encode(this.getPublicKeyCodec(verificationKey.algorithm(), verificationKey.publicKey().length).encode(verificationKey.publicKey())));
            embedded = true;
        }
        if (value instanceof KeyPair && (keyPair = (KeyPair)value).privateKey() != null) {
            builder.set(PRIVATE_KEY).scalar("https://w3id.org/security#multibase", Multibase.BASE_58_BTC.encode(this.getPrivateKeyCodec(keyPair.algorithm(), keyPair.privateKey().length).encode(keyPair.privateKey())));
            embedded = true;
        }
        if (embedded) {
            builder.type(value.type().toASCIIString());
        }
        return builder.build();
    }

    public static final String getAlgorithmName(Multicodec codec) {
        if (codec.name().endsWith("-priv")) {
            return codec.name().substring(0, codec.name().length() - "-priv".length()).toUpperCase();
        }
        if (codec.name().endsWith("-pub")) {
            return codec.name().substring(0, codec.name().length() - "-pub".length()).toUpperCase();
        }
        return codec.name().toUpperCase();
    }
}

