/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc;

import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.Term;
import com.apicatalog.ld.node.LdNode;
import com.apicatalog.ld.node.LdNodeBuilder;
import com.apicatalog.vc.ModelVersion;
import com.apicatalog.vc.VcVocab;
import com.apicatalog.vc.Verifiable;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.time.Instant;

public class Credential
extends Verifiable {
    protected Instant issuance;
    protected Instant expiration;
    protected Instant validUntil;
    protected Instant validFrom;
    protected JsonValue subject;
    protected JsonValue issuer;
    protected JsonValue status;

    protected Credential(ModelVersion version, JsonObject expanded) {
        super(version, expanded);
    }

    public Instant issuanceDate() {
        return this.issuance;
    }

    public void issuanceDate(Instant issuance) {
        this.issuance = issuance;
    }

    public Instant expiration() {
        return this.expiration;
    }

    public void expiration(Instant expiration) {
        this.expiration = expiration;
    }

    public Instant validFrom() {
        return this.validFrom;
    }

    public void validFrom(Instant validFrom) {
        this.validFrom = validFrom;
    }

    public Instant validUntil() {
        return this.validUntil;
    }

    public void validUntil(Instant validUntil) {
        this.validUntil = validUntil;
    }

    public boolean isExpired() {
        return this.expiration != null && this.expiration.isBefore(Instant.now()) || this.validUntil != null && this.validUntil.isBefore(Instant.now());
    }

    public boolean isNotValidYet() {
        return this.issuance != null && this.issuance.isAfter(Instant.now()) || this.validFrom != null && this.validFrom.isAfter(Instant.now());
    }

    public JsonValue issuer() {
        return this.issuer;
    }

    public JsonValue status() {
        return this.status;
    }

    public JsonValue subject() {
        return this.subject;
    }

    @Override
    public boolean isCredential() {
        return true;
    }

    @Override
    public Credential asCredential() {
        return this;
    }

    @Override
    public void validate() throws DocumentError {
        if ((this.version == null || ModelVersion.V11.equals((Object)this.version)) && this.issuance == null) {
            throw new DocumentError(DocumentError.ErrorType.Missing, VcVocab.ISSUANCE_DATE);
        }
        if (this.issuance != null && this.expiration != null && this.issuance.isAfter(this.expiration) || this.validFrom != null && this.validUntil != null && this.validFrom.isAfter(this.validUntil)) {
            throw new DocumentError(DocumentError.ErrorType.Invalid, "ValidityPeriod");
        }
    }

    public static boolean isCredential(JsonValue document) {
        if (document == null) {
            throw new IllegalArgumentException("The 'document' parameter must not be null.");
        }
        return LdNode.isTypeOf(VcVocab.CREDENTIAL_TYPE.uri(), document);
    }

    public static Credential of(ModelVersion version, JsonObject document) throws DocumentError {
        if (document == null) {
            throw new IllegalArgumentException("The 'document' parameter must not be null.");
        }
        Credential credential = new Credential(version, document);
        LdNode node = LdNode.of(document);
        credential.type = node.type().strings();
        if (!credential.type().contains(VcVocab.CREDENTIAL_TYPE.uri())) {
            if (credential.type().isEmpty()) {
                throw new DocumentError(DocumentError.ErrorType.Missing, Term.TYPE);
            }
            throw new DocumentError(DocumentError.ErrorType.Unknown, Term.TYPE);
        }
        if (!node.node(VcVocab.SUBJECT).exists()) {
            throw new DocumentError(DocumentError.ErrorType.Missing, VcVocab.SUBJECT);
        }
        credential.subject = (JsonValue)document.get((Object)VcVocab.SUBJECT.uri());
        credential.id = node.id();
        LdNode issuer = node.node(VcVocab.ISSUER);
        if (!issuer.exists()) {
            throw new DocumentError(DocumentError.ErrorType.Missing, VcVocab.ISSUER);
        }
        if (issuer.id() == null) {
            throw new DocumentError(DocumentError.ErrorType.Invalid, VcVocab.ISSUER);
        }
        credential.issuer = (JsonValue)document.get((Object)VcVocab.ISSUER.uri());
        credential.status = (JsonValue)document.get((Object)VcVocab.STATUS.uri());
        credential.issuanceDate(node.scalar(VcVocab.ISSUANCE_DATE).xsdDateTime());
        credential.expiration(node.scalar(VcVocab.EXPIRATION_DATE).xsdDateTime());
        credential.validFrom(node.scalar(VcVocab.VALID_FROM).xsdDateTime());
        credential.validUntil(node.scalar(VcVocab.VALID_UNTIL).xsdDateTime());
        return credential;
    }

    public JsonObject expand() {
        LdNodeBuilder builder = new LdNodeBuilder(Json.createObjectBuilder((JsonObject)this.expanded));
        if (this.issuance != null) {
            builder.set(VcVocab.ISSUANCE_DATE).xsdDateTime(this.issuance);
        }
        if (this.expiration != null) {
            builder.set(VcVocab.EXPIRATION_DATE).xsdDateTime(this.expiration);
        }
        if (this.validFrom != null) {
            builder.set(VcVocab.VALID_FROM).xsdDateTime(this.validFrom);
        }
        if (this.validUntil != null) {
            builder.set(VcVocab.VALID_UNTIL).xsdDateTime(this.validUntil);
        }
        return builder.build();
    }
}

