/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc;

import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.Term;
import com.apicatalog.ld.node.LdNode;
import com.apicatalog.vc.Credential;
import com.apicatalog.vc.ModelVersion;
import com.apicatalog.vc.VcVocab;
import com.apicatalog.vc.Verifiable;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class Presentation
extends Verifiable {
    protected URI holder;
    protected Collection<Credential> credentials;

    protected Presentation(ModelVersion version, JsonObject expanded) {
        super(version, expanded);
    }

    @Override
    public boolean isPresentation() {
        return true;
    }

    @Override
    public Presentation asPresentation() {
        return this;
    }

    public Collection<Credential> credentials() {
        return this.credentials;
    }

    public URI holder() {
        return this.holder;
    }

    public void credentials(Collection<Credential> credentials) {
        this.credentials = credentials;
    }

    @Override
    public void validate() throws DocumentError {
    }

    public static boolean isPresentation(JsonValue document) {
        if (document == null) {
            throw new IllegalArgumentException("The 'document' parameter must not be null.");
        }
        return LdNode.isTypeOf(VcVocab.PRESENTATION_TYPE.uri(), document);
    }

    public static Presentation of(ModelVersion version, JsonObject document) throws DocumentError {
        if (document == null) {
            throw new IllegalArgumentException("The 'document' parameter must not be null.");
        }
        Presentation presentation = new Presentation(version, document);
        if (!LdNode.isTypeOf(VcVocab.PRESENTATION_TYPE.uri(), (JsonValue)document)) {
            if (LdNode.hasType((JsonValue)document)) {
                throw new DocumentError(DocumentError.ErrorType.Unknown, Term.TYPE);
            }
            throw new DocumentError(DocumentError.ErrorType.Missing, Term.TYPE);
        }
        LdNode node = LdNode.of(document);
        presentation.id = node.id();
        presentation.holder = node.node(VcVocab.HOLDER).id();
        return presentation;
    }

    public static Collection<JsonObject> getCredentials(JsonObject document) throws DocumentError {
        JsonValue credentials = (JsonValue)document.get((Object)VcVocab.VERIFIABLE_CREDENTIALS.uri());
        if (JsonUtils.isNotArray((JsonValue)credentials) || credentials.asJsonArray().size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<JsonObject> result = new ArrayList<JsonObject>(credentials.asJsonArray().size());
        for (JsonValue cred : credentials.asJsonArray()) {
            if (JsonUtils.isNotObject((JsonValue)cred) || JsonUtils.isNotArray((JsonValue)((JsonValue)cred.asJsonObject().get((Object)"@graph"))) || cred.asJsonObject().getJsonArray("@graph").size() != 1 || JsonUtils.isNotObject((JsonValue)((JsonValue)cred.asJsonObject().getJsonArray("@graph").get(0)))) {
                throw new DocumentError(DocumentError.ErrorType.Invalid, "https://www.w3.org/2018/credentials#");
            }
            result.add(cred.asJsonObject().getJsonArray("@graph").getJsonObject(0));
        }
        return result;
    }

    static JsonObject setCredentials(JsonObject document, Collection<Credential> credentials) throws DocumentError {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        credentials.stream().map(c -> Json.createObjectBuilder().add("@graph", Json.createArrayBuilder().add((JsonValue)c.expand()))).forEach(arg_0 -> ((JsonArrayBuilder)builder).add(arg_0));
        return Json.createObjectBuilder((JsonObject)document).add(VcVocab.VERIFIABLE_CREDENTIALS.uri(), builder).build();
    }
}

