/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc;

import com.apicatalog.jsonld.JsonLd;
import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.uri.UriUtils;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.Term;
import com.apicatalog.vc.Credential;
import com.apicatalog.vc.ModelVersion;
import com.apicatalog.vc.Presentation;
import com.apicatalog.vc.proof.Proof;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.net.URI;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Verifiable {
    private static final Logger LOGGER = Logger.getLogger(Verifiable.class.getName());
    protected final ModelVersion version;
    protected URI id;
    protected Collection<Proof> proofs;
    protected Collection<String> type;
    protected JsonObject expanded;

    protected Verifiable(ModelVersion version, JsonObject expanded) {
        this.version = version;
        this.expanded = expanded;
    }

    public URI id() {
        return this.id;
    }

    public Collection<String> type() {
        return this.type;
    }

    public Collection<Proof> proofs() {
        return this.proofs;
    }

    public void proofs(Collection<Proof> proofs) {
        this.proofs = proofs;
    }

    public boolean isCredential() {
        return false;
    }

    public boolean isPresentation() {
        return false;
    }

    public Credential asCredential() {
        throw new ClassCastException();
    }

    public Presentation asPresentation() {
        throw new ClassCastException();
    }

    public ModelVersion version() {
        return this.version;
    }

    public static ModelVersion getVersion(JsonObject object) throws DocumentError {
        JsonValue contexts = (JsonValue)object.get((Object)"@context");
        for (JsonValue context : JsonUtils.toCollection((JsonValue)contexts)) {
            if (!JsonUtils.isScalar((JsonValue)context) || !UriUtils.isURI((String)((JsonString)context).getString())) continue;
            String contextUri = ((JsonString)context).getString();
            if ("https://www.w3.org/2018/credentials/v1".equals(contextUri)) {
                return ModelVersion.V11;
            }
            if (!"https://www.w3.org/ns/credentials/v2".equals(contextUri)) continue;
            if (JsonUtils.isNotArray((JsonValue)contexts)) {
                LOGGER.log(Level.INFO, "VC model requires @context declaration be an array, it is inconsistent with another requirement on compaction. Therefore this requirement is not enforced by Iron VC");
            }
            return ModelVersion.V20;
        }
        return ModelVersion.V20;
    }

    public static Verifiable of(ModelVersion version, JsonObject expanded) throws DocumentError {
        if (Credential.isCredential((JsonValue)expanded)) {
            return Credential.of(version, expanded);
        }
        if (Presentation.isPresentation((JsonValue)expanded)) {
            return Presentation.of(version, expanded);
        }
        if (JsonUtils.isNull((JsonValue)((JsonValue)expanded.get((Object)"@type")))) {
            throw new DocumentError(DocumentError.ErrorType.Missing, Term.TYPE);
        }
        throw new DocumentError(DocumentError.ErrorType.Unknown, Term.TYPE);
    }

    public abstract void validate() throws DocumentError;

    static JsonObject compact(JsonObject signed, JsonStructure context, DocumentLoader loader) throws DocumentError {
        try {
            return Verifiable.postCompact(JsonLd.compact((Document)JsonDocument.of((JsonStructure)signed), (Document)JsonDocument.of((JsonStructure)context)).loader(loader).get());
        }
        catch (JsonLdError e) {
            DocumentError.failWithJsonLd(e);
            throw new DocumentError((Throwable)e, DocumentError.ErrorType.Invalid, new Term[0]);
        }
    }

    static JsonObject postCompact(JsonObject source) {
        JsonObject compacted = source;
        if (!((String)compacted.keySet().iterator().next()).equals("@context")) {
            JsonObjectBuilder builder = Json.createObjectBuilder().add("@context", (JsonValue)JsonUtils.toJsonArray((JsonValue)((JsonValue)compacted.get((Object)"@context"))));
            compacted.entrySet().stream().filter(entry -> !"@context".equals(entry.getKey())).forEach(entry -> builder.add((String)entry.getKey(), (JsonValue)entry.getValue()));
            compacted = builder.build();
        }
        return compacted;
    }
}

