/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc.holder;

import com.apicatalog.jsonld.JsonLd;
import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.Term;
import com.apicatalog.ld.node.LdType;
import com.apicatalog.ld.signature.SigningError;
import com.apicatalog.ld.signature.sd.DocumentSelector;
import com.apicatalog.vc.Credential;
import com.apicatalog.vc.Presentation;
import com.apicatalog.vc.VcVocab;
import com.apicatalog.vc.processor.AbstractProcessor;
import com.apicatalog.vc.processor.ExpandedVerifiable;
import com.apicatalog.vc.proof.BaseProofValue;
import com.apicatalog.vc.proof.EmbeddedProof;
import com.apicatalog.vc.proof.Proof;
import com.apicatalog.vc.proof.ProofValue;
import com.apicatalog.vc.suite.SignatureSuite;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Holder
extends AbstractProcessor<Holder> {
    protected Holder(SignatureSuite ... suites) {
        super(suites);
    }

    public static Holder with(SignatureSuite ... suites) {
        return new Holder(suites);
    }

    public ExpandedVerifiable derive(JsonObject document, Collection<String> selectors) throws SigningError, DocumentError {
        Objects.requireNonNull(document);
        return this.derive(document, selectors, this.getLoader());
    }

    protected ExpandedVerifiable derive(JsonObject document, Collection<String> selectors, DocumentLoader loader) throws SigningError, DocumentError {
        try {
            JsonArray context = document.containsKey((Object)"@context") ? JsonUtils.toJsonArray((JsonValue)((JsonValue)document.get((Object)"@context"))) : null;
            JsonArray expanded = JsonLd.expand((Document)JsonDocument.of((JsonStructure)document)).loader(loader).base(this.base).get();
            return this.deriveExpanded(document, (JsonStructure)context, expanded, selectors, loader);
        }
        catch (JsonLdError e) {
            DocumentError.failWithJsonLd(e);
            throw new DocumentError((Throwable)e, DocumentError.ErrorType.Invalid, new Term[0]);
        }
    }

    private ExpandedVerifiable deriveExpanded(JsonObject document, JsonStructure context, JsonArray expanded, Collection<String> selectors, DocumentLoader loader) throws SigningError, DocumentError {
        if (expanded == null || expanded.isEmpty() || expanded.size() > 1) {
            throw new DocumentError(DocumentError.ErrorType.Invalid, new Term[0]);
        }
        JsonValue verifiable = (JsonValue)expanded.iterator().next();
        if (JsonUtils.isNotObject((JsonValue)verifiable)) {
            throw new DocumentError(DocumentError.ErrorType.Invalid, new Term[0]);
        }
        return this.deriveExpanded(document, context, verifiable.asJsonObject(), selectors, loader);
    }

    private ExpandedVerifiable deriveExpanded(JsonObject document, JsonStructure context, JsonObject expanded, Collection<String> selectors, DocumentLoader loader) throws SigningError, DocumentError {
        if (Credential.isCredential((JsonValue)expanded)) {
            return this.deriveProof(context, document, expanded, selectors, loader);
        }
        if (Presentation.isPresentation((JsonValue)expanded)) {
            // empty if block
        }
        throw new DocumentError(DocumentError.ErrorType.Unknown, Term.TYPE);
    }

    protected ExpandedVerifiable deriveProof(JsonStructure context, JsonObject document, JsonObject expanded, Collection<String> selectors, DocumentLoader loader) throws DocumentError, SigningError {
        Collection<JsonObject> expandedProofs = EmbeddedProof.assertProof(expanded);
        if (expandedProofs.size() > 1) {
            throw new DocumentError(DocumentError.ErrorType.Invalid, new Term[0]);
        }
        JsonObject unsigned = EmbeddedProof.removeProofs(expanded);
        JsonObject expandedProof = expandedProofs.iterator().next();
        Collection<String> proofTypes = LdType.strings(expandedProof);
        if (proofTypes == null || proofTypes.isEmpty()) {
            throw new DocumentError(DocumentError.ErrorType.Missing, VcVocab.PROOF, Term.TYPE);
        }
        SignatureSuite signatureSuite = this.findSuite(proofTypes, expandedProof);
        if (signatureSuite == null) {
            throw new SigningError(SigningError.Code.UnsupportedCryptoSuite);
        }
        Proof proof = signatureSuite.getProof(expandedProof, loader);
        if (proof == null) {
            throw new IllegalStateException("The suite [" + signatureSuite + "] returns null as a proof.");
        }
        ProofValue proofValue = proof.signature();
        if (proofValue == null) {
            throw new DocumentError(DocumentError.ErrorType.Missing, "ProofValue");
        }
        if (!(proofValue instanceof BaseProofValue)) {
            throw new DocumentError(DocumentError.ErrorType.Invalid, "ProofValue");
        }
        JsonObject derivedProof = proof.derive(context, unsigned, selectors);
        Collection combinedPointers = Stream.of(((BaseProofValue)proofValue).pointers(), selectors != null ? selectors : Collections.emptyList(), Arrays.asList("/@context")).flatMap(Collection::stream).collect(Collectors.toList());
        JsonObject reveal = DocumentSelector.of(combinedPointers).getNodes(document);
        try {
            return new ExpandedVerifiable(EmbeddedProof.addProof(JsonLd.expand((Document)JsonDocument.of((JsonStructure)reveal)).loader(loader).get().getJsonObject(0), derivedProof), context, loader);
        }
        catch (JsonLdError e) {
            throw new DocumentError((Throwable)e, DocumentError.ErrorType.Invalid, new Term[0]);
        }
    }
}

