/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc.integrity;

import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.Term;
import com.apicatalog.ld.node.LdScalar;
import com.apicatalog.ld.signature.CryptoSuite;
import com.apicatalog.ld.signature.SigningError;
import com.apicatalog.ld.signature.VerificationError;
import com.apicatalog.ld.signature.VerificationMethod;
import com.apicatalog.ld.signature.key.VerificationKey;
import com.apicatalog.vc.integrity.DataIntegrityProofDraft;
import com.apicatalog.vc.integrity.DataIntegritySuite;
import com.apicatalog.vc.integrity.DataIntegrityVocab;
import com.apicatalog.vc.method.MethodAdapter;
import com.apicatalog.vc.proof.BaseProofValue;
import com.apicatalog.vc.proof.Proof;
import com.apicatalog.vc.proof.ProofValue;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import java.net.URI;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public class DataIntegrityProof
implements Proof,
MethodAdapter {
    protected final DataIntegritySuite suite;
    protected final CryptoSuite crypto;
    protected final JsonObject expanded;
    protected URI id;
    protected URI purpose;
    protected VerificationMethod method;
    protected Instant created;
    protected String domain;
    protected String nonce;
    protected String challenge;
    protected ProofValue value;
    protected URI previousProof;

    protected DataIntegrityProof(DataIntegritySuite suite, CryptoSuite crypto, JsonObject expandedProof) {
        this.suite = suite;
        this.crypto = crypto;
        this.expanded = expandedProof;
    }

    @Override
    public void verify(JsonStructure context, JsonObject data, VerificationKey method) throws VerificationError, DocumentError {
        Objects.requireNonNull(this.value);
        Objects.requireNonNull(data);
        Objects.requireNonNull(method);
        JsonObject unsignedProof = this.unsignedCopy();
        this.value.verify(this.crypto, context, data, unsignedProof, method.publicKey());
    }

    @Override
    public void validate(Map<String, Object> params) throws DocumentError {
        if (this.created == null) {
            throw new DocumentError(DocumentError.ErrorType.Missing, "Created");
        }
        if (this.method == null) {
            throw new DocumentError(DocumentError.ErrorType.Missing, "VerificationMethod");
        }
        if (this.purpose == null) {
            throw new DocumentError(DocumentError.ErrorType.Missing, "ProofPurpose");
        }
        if (this.value == null) {
            throw new DocumentError(DocumentError.ErrorType.Missing, "ProofValue");
        }
        if (params != null) {
            DataIntegrityProof.assertEquals(params, DataIntegrityVocab.PURPOSE, this.purpose.toString());
            DataIntegrityProof.assertEquals(params, DataIntegrityVocab.CHALLENGE, this.challenge);
            DataIntegrityProof.assertEquals(params, DataIntegrityVocab.DOMAIN, this.domain);
        }
    }

    public URI getPurpose() {
        return this.purpose;
    }

    @Override
    public VerificationMethod method() {
        return this.method;
    }

    public Instant getCreated() {
        return this.created;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getChallenge() {
        return this.challenge;
    }

    public String nonce() {
        return this.nonce;
    }

    @Override
    public ProofValue signature() {
        return this.value;
    }

    @Override
    public URI id() {
        return this.id;
    }

    @Override
    public URI previousProof() {
        return this.previousProof;
    }

    @Override
    public CryptoSuite cryptoSuite() {
        return this.crypto;
    }

    @Override
    public MethodAdapter methodProcessor() {
        return this;
    }

    @Override
    public VerificationMethod read(JsonObject expanded) throws DocumentError {
        return this.suite.methodAdapter.read(expanded);
    }

    @Override
    public JsonObject write(VerificationMethod value) {
        throw new UnsupportedOperationException();
    }

    protected static void assertEquals(Map<String, Object> params, Term name, String param) throws DocumentError {
        Object value = params.get(name.name());
        if (value == null) {
            return;
        }
        if (!value.equals(param)) {
            throw new DocumentError(DocumentError.ErrorType.Invalid, name);
        }
    }

    protected JsonObject unsignedCopy() {
        return Json.createObjectBuilder((JsonObject)this.expanded).remove(DataIntegrityVocab.PROOF_VALUE.uri()).build();
    }

    @Override
    public JsonObject derive(JsonStructure context, JsonObject data, Collection<String> selectors) throws SigningError, DocumentError {
        ProofValue derivedProofValue = ((BaseProofValue)this.value).derive(context, data, selectors);
        JsonObject signature = LdScalar.multibase(this.suite.proofValueBase, derivedProofValue.toByteArray());
        return DataIntegrityProofDraft.signed(this.unsignedCopy(), signature);
    }
}

