/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc.integrity;

import com.apicatalog.ld.node.LdNodeBuilder;
import com.apicatalog.ld.signature.CryptoSuite;
import com.apicatalog.ld.signature.VerificationMethod;
import com.apicatalog.vc.ModelVersion;
import com.apicatalog.vc.integrity.DataIntegritySuite;
import com.apicatalog.vc.integrity.DataIntegrityVocab;
import com.apicatalog.vc.issuer.ProofDraft;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.net.URI;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;

public class DataIntegrityProofDraft
extends ProofDraft {
    protected static final Collection<String> V1_CONTEXTS = Arrays.asList("https://w3id.org/security/data-integrity/v2", "https://w3id.org/security/multikey/v1");
    protected static final Collection<String> V2_CONTEXTS = Arrays.asList("https://www.w3.org/ns/credentials/v2");
    protected final DataIntegritySuite suite;
    protected final URI purpose;
    protected Instant created;
    protected String domain;
    protected String challenge;
    protected String nonce;

    public DataIntegrityProofDraft(DataIntegritySuite suite, CryptoSuite crypto, VerificationMethod method, URI purpose) {
        super(crypto, method);
        this.suite = suite;
        this.purpose = purpose;
    }

    public DataIntegrityProofDraft(DataIntegritySuite suite, CryptoSuite crypto, URI method, URI purpose) {
        super(crypto, method);
        this.suite = suite;
        this.purpose = purpose;
    }

    public void created(Instant created) {
        this.created = created;
    }

    public void challenge(String challenge) {
        this.challenge = challenge;
    }

    public void domain(String domain) {
        this.domain = domain;
    }

    public void nonce(String nonce) {
        this.nonce = nonce;
    }

    @Override
    public Collection<String> context(ModelVersion model) {
        if (ModelVersion.V11.equals((Object)model)) {
            return V1_CONTEXTS;
        }
        return V2_CONTEXTS;
    }

    @Override
    public JsonObject unsigned() {
        return this.unsigned(new LdNodeBuilder()).build();
    }

    public static final JsonObject signed(JsonObject unsignedProof, JsonObject proofValue) {
        return LdNodeBuilder.of(unsignedProof).set(DataIntegrityVocab.PROOF_VALUE).value((JsonValue)proofValue).build();
    }

    protected LdNodeBuilder unsigned(LdNodeBuilder builder) {
        super.unsigned(builder, this.suite.methodAdapter);
        builder.type("https://w3id.org/security#DataIntegrityProof");
        builder.set(DataIntegrityVocab.CRYPTO_SUITE).scalar("https://w3id.org/security#cryptosuiteString", this.suite.cryptosuite);
        builder.set(DataIntegrityVocab.PURPOSE).id(this.purpose);
        builder.set(DataIntegrityVocab.CREATED).xsdDateTime(this.created != null ? this.created : Instant.now());
        if (this.domain != null) {
            builder.set(DataIntegrityVocab.DOMAIN).string(this.domain);
        }
        if (this.challenge != null) {
            builder.set(DataIntegrityVocab.CHALLENGE).string(this.challenge);
        }
        if (this.nonce != null) {
            builder.set(DataIntegrityVocab.NONCE).string(this.nonce);
        }
        return builder;
    }
}

