/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc.issuer;

import com.apicatalog.jsonld.JsonLd;
import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import com.apicatalog.jsonld.loader.SchemeRouter;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.Term;
import com.apicatalog.ld.node.LdNodeBuilder;
import com.apicatalog.ld.node.LdScalar;
import com.apicatalog.ld.signature.SigningError;
import com.apicatalog.ld.signature.key.KeyPair;
import com.apicatalog.multibase.Multibase;
import com.apicatalog.vc.ModelVersion;
import com.apicatalog.vc.VcVocab;
import com.apicatalog.vc.Verifiable;
import com.apicatalog.vc.integrity.DataIntegrityProofDraft;
import com.apicatalog.vc.integrity.DataIntegrityVocab;
import com.apicatalog.vc.issuer.Issuer;
import com.apicatalog.vc.issuer.ProofDraft;
import com.apicatalog.vc.loader.StaticContextLoader;
import com.apicatalog.vc.processor.ExpandedVerifiable;
import com.apicatalog.vc.proof.EmbeddedProof;
import com.apicatalog.vc.suite.SignatureSuite;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.net.URI;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashSet;

public abstract class AbstractIssuer
implements Issuer {
    protected final SignatureSuite suite;
    protected final KeyPair keyPair;
    protected final Multibase proofValueBase;
    protected DocumentLoader defaultLoader;
    protected URI base;
    protected boolean bundledContexts;

    protected AbstractIssuer(SignatureSuite suite, KeyPair keyPair, Multibase proofValueBase) {
        this.suite = suite;
        this.keyPair = keyPair;
        this.proofValueBase = proofValueBase;
        this.defaultLoader = null;
        this.base = null;
        this.bundledContexts = true;
    }

    @Override
    public ExpandedVerifiable sign(URI location, ProofDraft draft) throws SigningError, DocumentError {
        DocumentLoader loader = this.getLoader();
        return this.sign(AbstractIssuer.fetchDocument(location, loader), draft, loader);
    }

    @Override
    public ExpandedVerifiable sign(JsonObject document, ProofDraft draft) throws SigningError, DocumentError {
        return this.sign(document, draft, this.getLoader());
    }

    @Override
    public Issuer base(URI base) {
        this.base = base;
        return this;
    }

    @Override
    public Issuer loader(DocumentLoader loader) {
        this.defaultLoader = loader;
        return this;
    }

    @Override
    public Issuer useBundledContexts(boolean enable) {
        this.bundledContexts = enable;
        return this;
    }

    protected ExpandedVerifiable sign(JsonObject document, ProofDraft draft, DocumentLoader loader) throws SigningError, DocumentError {
        try {
            JsonValue object;
            JsonArray expanded = JsonLd.expand((Document)JsonDocument.of((JsonStructure)document)).loader(loader).base(this.base).get();
            if (expanded.size() == 1 && JsonUtils.isObject((JsonValue)(object = (JsonValue)expanded.iterator().next()))) {
                ModelVersion version = Verifiable.getVersion(document);
                return this.sign(version, this.getContext(version, document, draft), object.asJsonObject(), draft, loader);
            }
            throw new DocumentError(DocumentError.ErrorType.Invalid, new Term[0]);
        }
        catch (JsonLdError e) {
            DocumentError.failWithJsonLd(e);
            throw new DocumentError((Throwable)e, DocumentError.ErrorType.Invalid, new Term[0]);
        }
    }

    protected ExpandedVerifiable sign(ModelVersion version, JsonArray context, JsonObject expanded, ProofDraft draft, DocumentLoader loader) throws SigningError, DocumentError {
        if (this.keyPair.privateKey() == null || this.keyPair.privateKey().length == 0) {
            throw new IllegalArgumentException("The private key is not provided, is null or an empty array.");
        }
        JsonObject object = expanded;
        Verifiable verifiable = Verifiable.of(version, object);
        if (verifiable.isCredential() && verifiable.asCredential().isExpired()) {
            throw new SigningError(SigningError.Code.Expired);
        }
        verifiable.validate();
        if (verifiable.isCredential() && (verifiable.version() == null || ModelVersion.V11.equals((Object)verifiable.version())) && verifiable.asCredential().issuanceDate() == null) {
            Instant issuanceDate = Instant.now().truncatedTo(ChronoUnit.SECONDS);
            object = Json.createObjectBuilder((JsonObject)object).add(VcVocab.ISSUANCE_DATE.uri(), issuanceDate.toString()).build();
        }
        JsonObject unsigned = EmbeddedProof.removeProofs(object);
        byte[] signature = this.sign(context, unsigned, draft);
        JsonObject proofValue = LdScalar.multibase(this.proofValueBase, signature);
        JsonObject signedProof = DataIntegrityProofDraft.signed(draft.unsigned(), proofValue);
        return new ExpandedVerifiable(EmbeddedProof.addProof(object, signedProof), (JsonStructure)context, loader);
    }

    protected JsonObject signed1Copy(JsonObject unsigned, JsonObject signature) {
        return new LdNodeBuilder(unsigned).set(DataIntegrityVocab.PROOF_VALUE).value((JsonValue)signature).build();
    }

    protected abstract byte[] sign(JsonArray var1, JsonObject var2, ProofDraft var3) throws SigningError, DocumentError;

    protected JsonArray getContext(ModelVersion version, JsonObject document, ProofDraft draft) {
        Collection<String> provided;
        HashSet<String> urls = new HashSet<String>();
        JsonArrayBuilder contexts = Json.createArrayBuilder();
        if (document != null && document.containsKey((Object)"@context")) {
            JsonValue documentContext = (JsonValue)document.get((Object)"@context");
            if (JsonUtils.isString((JsonValue)documentContext)) {
                urls.add(((JsonString)documentContext).getString());
                contexts.add(documentContext);
            } else if (JsonUtils.isObject((JsonValue)documentContext)) {
                contexts.add(documentContext);
            } else if (JsonUtils.isArray((JsonValue)documentContext)) {
                for (JsonValue context : documentContext.asJsonArray()) {
                    if (JsonUtils.isString((JsonValue)context)) {
                        urls.add(((JsonString)context).getString());
                    }
                    contexts.add(context);
                }
            }
        }
        if ((provided = draft.context(version)) != null) {
            for (String url : provided) {
                if (urls.contains(url)) continue;
                urls.add(url);
                contexts.add((JsonValue)Json.createValue((String)url));
            }
        }
        return contexts.build();
    }

    protected static final JsonObject fetchDocument(URI location, DocumentLoader loader) throws DocumentError, SigningError {
        try {
            DocumentLoaderOptions options = new DocumentLoaderOptions();
            Document loadedDocument = loader.loadDocument(location, options);
            JsonStructure json = (JsonStructure)loadedDocument.getJsonContent().orElseThrow(() -> new DocumentError(DocumentError.ErrorType.Invalid, new Term[0]));
            if (JsonUtils.isNotObject((JsonValue)json)) {
                throw new DocumentError(DocumentError.ErrorType.Invalid, new Term[0]);
            }
            return json.asJsonObject();
        }
        catch (JsonLdError e) {
            DocumentError.failWithJsonLd(e);
            throw new DocumentError((Throwable)e, DocumentError.ErrorType.Invalid, new Term[0]);
        }
    }

    protected DocumentLoader getLoader() {
        DocumentLoader loader = this.defaultLoader;
        if (loader == null) {
            loader = SchemeRouter.defaultInstance();
        }
        if (this.bundledContexts) {
            loader = new StaticContextLoader(loader);
        }
        return loader;
    }
}

