/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc.issuer;

import com.apicatalog.ld.node.LdNodeBuilder;
import com.apicatalog.ld.signature.CryptoSuite;
import com.apicatalog.ld.signature.VerificationMethod;
import com.apicatalog.vc.ModelVersion;
import com.apicatalog.vc.integrity.DataIntegrityVocab;
import com.apicatalog.vc.method.MethodAdapter;
import jakarta.json.JsonObject;
import java.net.URI;
import java.util.Collection;

public abstract class ProofDraft {
    protected final CryptoSuite crypto;
    protected final VerificationMethod method;
    protected final URI verificatonUrl;
    protected URI id;
    protected URI previousProof;

    protected ProofDraft(CryptoSuite crypto, VerificationMethod method) {
        this.crypto = crypto;
        this.method = method;
        this.verificatonUrl = null;
        this.id = null;
        this.previousProof = null;
    }

    protected ProofDraft(CryptoSuite crypto, URI verificatonUrl) {
        this.crypto = crypto;
        this.method = null;
        this.verificatonUrl = verificatonUrl;
        this.id = null;
        this.previousProof = null;
    }

    public abstract Collection<String> context(ModelVersion var1);

    public abstract JsonObject unsigned();

    public CryptoSuite cryptoSuite() {
        return this.crypto;
    }

    public void id(URI id) {
        this.id = id;
    }

    public void previousProof(URI previousProof) {
        this.previousProof = previousProof;
    }

    protected LdNodeBuilder unsigned(LdNodeBuilder builder, MethodAdapter adapter) {
        if (this.id != null) {
            builder.id(this.id);
        }
        if (this.previousProof != null) {
            builder.set(DataIntegrityVocab.PREVIOUS_PROOF).id(this.previousProof);
        }
        if (this.verificatonUrl != null) {
            builder.set(DataIntegrityVocab.VERIFICATION_METHOD).id(this.verificatonUrl);
        } else if (this.method != null) {
            builder.set(DataIntegrityVocab.VERIFICATION_METHOD).map(adapter, this.method);
        }
        return builder;
    }
}

