/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc.loader;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import com.apicatalog.vc.VcVocab;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class StaticContextLoader
implements DocumentLoader {
    protected static final Map<String, Document> staticCache = StaticContextLoader.defaultValues();
    protected final DocumentLoader defaultLoader;

    public StaticContextLoader(DocumentLoader defaultLoader) {
        this.defaultLoader = defaultLoader;
    }

    public Document loadDocument(URI url, DocumentLoaderOptions options) throws JsonLdError {
        Document document = staticCache.get(url.toString());
        if (document != null) {
            return document;
        }
        return this.defaultLoader.loadDocument(url, options);
    }

    public static Map<String, Document> defaultValues() {
        LinkedHashMap<String, JsonDocument> staticCache = new LinkedHashMap<String, JsonDocument>();
        staticCache.put("https://www.w3.org/2018/credentials/examples/v1", StaticContextLoader.get("2018-credentials-examples-v1.jsonld"));
        staticCache.put("https://www.w3.org/2018/credentials/v1", StaticContextLoader.get("2018-credentials-v1.jsonld"));
        staticCache.put("https://www.w3.org/ns/credentials/examples/v2", StaticContextLoader.get("2023-credentials-examples-v2.jsonld"));
        staticCache.put("https://www.w3.org/ns/credentials/v2", StaticContextLoader.get("2023-credentials-v2.jsonld"));
        staticCache.put("https://www.w3.org/ns/odrl.jsonld", StaticContextLoader.get("odrl.jsonld"));
        staticCache.put("https://www.w3.org/ns/did/v1", StaticContextLoader.get("did-v1.jsonld"));
        staticCache.put("https://w3id.org/security/data-integrity/v1", StaticContextLoader.get("data-integrity-v1.jsonld"));
        staticCache.put("https://w3id.org/security/data-integrity/v2", StaticContextLoader.get("data-integrity-v2.jsonld"));
        staticCache.put("https://w3id.org/security/multikey/v1", StaticContextLoader.get("multikey-v1.jsonld"));
        return Collections.unmodifiableMap(staticCache);
    }

    protected static JsonDocument get(String name) {
        JsonDocument jsonDocument;
        block8: {
            InputStream is = VcVocab.class.getResourceAsStream(name);
            try {
                jsonDocument = JsonDocument.of((InputStream)is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonLdError | IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            is.close();
        }
        return jsonDocument;
    }
}

