/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc.method.resolver;

import com.apicatalog.jsonld.JsonLd;
import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.signature.VerificationMethod;
import com.apicatalog.vc.method.resolver.MethodResolver;
import com.apicatalog.vc.proof.Proof;
import jakarta.json.JsonArray;
import jakarta.json.JsonValue;
import java.net.URI;

public class HttpMethodResolver
implements MethodResolver {
    @Override
    public VerificationMethod resolve(URI id, DocumentLoader loader, Proof proof) throws DocumentError {
        try {
            JsonArray document = JsonLd.expand((URI)id).loader(loader).context(proof.methodProcessor().context()).get();
            for (JsonValue method : document) {
                if (!JsonUtils.isObject((JsonValue)method)) continue;
                return proof.methodProcessor().read(method.asJsonObject());
            }
        }
        catch (JsonLdError e) {
            e.printStackTrace();
            throw new DocumentError((Throwable)e, DocumentError.ErrorType.Invalid, "ProofVerificationMethod");
        }
        throw new DocumentError(DocumentError.ErrorType.Unknown, "ProofVerificationMethod");
    }

    @Override
    public boolean isAccepted(URI id) {
        return "http".equalsIgnoreCase(id.getScheme()) || "https".equalsIgnoreCase(id.getScheme());
    }
}

