/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc.processor;

import com.apicatalog.jsonld.JsonLd;
import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import com.apicatalog.jsonld.loader.SchemeRouter;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.Term;
import com.apicatalog.ld.signature.VerificationError;
import com.apicatalog.ld.signature.VerificationMethod;
import com.apicatalog.ld.signature.key.VerificationKey;
import com.apicatalog.multibase.MultibaseDecoder;
import com.apicatalog.multicodec.Multicodec;
import com.apicatalog.multicodec.MulticodecDecoder;
import com.apicatalog.vc.ModelVersion;
import com.apicatalog.vc.loader.StaticContextLoader;
import com.apicatalog.vc.method.resolver.DidUrlMethodResolver;
import com.apicatalog.vc.method.resolver.HttpMethodResolver;
import com.apicatalog.vc.method.resolver.MethodResolver;
import com.apicatalog.vc.proof.Proof;
import com.apicatalog.vc.suite.SignatureSuite;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;

public abstract class AbstractProcessor<T extends AbstractProcessor<T>> {
    protected final SignatureSuite[] suites;
    protected DocumentLoader defaultLoader;
    protected boolean bundledContexts;
    protected URI base;
    protected ModelVersion modelVersion;
    protected Collection<MethodResolver> methodResolvers;

    protected AbstractProcessor(SignatureSuite ... suites) {
        this.suites = suites;
        this.defaultLoader = null;
        this.bundledContexts = true;
        this.base = null;
        this.modelVersion = null;
        this.methodResolvers = AbstractProcessor.defaultResolvers();
    }

    public T loader(DocumentLoader loader) {
        this.defaultLoader = loader;
        return (T)this;
    }

    public T useBundledContexts(boolean enable) {
        this.bundledContexts = enable;
        return (T)this;
    }

    public T base(URI base) {
        this.base = base;
        return (T)this;
    }

    protected static final Collection<MethodResolver> defaultResolvers() {
        LinkedHashSet<MethodResolver> resolvers = new LinkedHashSet<MethodResolver>();
        resolvers.add(new DidUrlMethodResolver(MultibaseDecoder.getInstance(), MulticodecDecoder.getInstance((Multicodec.Tag[])new Multicodec.Tag[]{Multicodec.Tag.Key})));
        resolvers.add(new HttpMethodResolver());
        return resolvers;
    }

    public T methodResolvers(Collection<MethodResolver> resolvers) {
        this.methodResolvers = resolvers;
        return (T)this;
    }

    protected DocumentLoader getLoader() {
        DocumentLoader loader = this.defaultLoader;
        if (loader == null) {
            loader = SchemeRouter.defaultInstance();
        }
        if (this.bundledContexts) {
            loader = new StaticContextLoader(loader);
        }
        return loader;
    }

    protected JsonObject fetch(URI location, DocumentLoader loader) throws DocumentError {
        try {
            DocumentLoaderOptions options = new DocumentLoaderOptions();
            Document loadedDocument = loader.loadDocument(location, options);
            JsonStructure json = (JsonStructure)loadedDocument.getJsonContent().orElseThrow(() -> new DocumentError(DocumentError.ErrorType.Invalid, new Term[0]));
            if (JsonUtils.isNotObject((JsonValue)json)) {
                throw new DocumentError(DocumentError.ErrorType.Invalid, new Term[0]);
            }
            return json.asJsonObject();
        }
        catch (JsonLdError e) {
            DocumentError.failWithJsonLd(e);
            throw new DocumentError((Throwable)e, DocumentError.ErrorType.Invalid, new Term[0]);
        }
    }

    protected JsonArray expand(JsonObject document, DocumentLoader loader) throws VerificationError, DocumentError {
        try {
            return JsonLd.expand((Document)JsonDocument.of((JsonStructure)document)).loader(loader).base(this.base).get();
        }
        catch (JsonLdError e) {
            DocumentError.failWithJsonLd(e);
            throw new DocumentError((Throwable)e, DocumentError.ErrorType.Invalid, new Term[0]);
        }
    }

    protected Optional<VerificationMethod> getMethod(Proof proof, DocumentLoader loader) throws VerificationError, DocumentError {
        VerificationMethod method = proof.method();
        if (method == null) {
            throw new DocumentError(DocumentError.ErrorType.Missing, "ProofVerificationMethod");
        }
        URI methodType = method.type();
        if (methodType != null && method instanceof VerificationKey && ((VerificationKey)method).publicKey() != null) {
            return Optional.of(method);
        }
        return this.resolveMethod(method.id(), proof, loader);
    }

    protected Optional<VerificationMethod> resolveMethod(URI id, Proof proof, DocumentLoader loader) throws DocumentError {
        if (id == null) {
            throw new DocumentError(DocumentError.ErrorType.Missing, "ProofVerificationId");
        }
        Optional<MethodResolver> resolver = this.methodResolvers.stream().filter(r -> r.isAccepted(id)).findFirst();
        if (resolver.isPresent()) {
            return Optional.ofNullable(resolver.get().resolve(id, loader, proof));
        }
        throw new DocumentError(DocumentError.ErrorType.Unknown, "ProofVerificationId");
    }

    protected SignatureSuite findSuite(Collection<String> proofTypes, JsonObject expandedProof) {
        for (SignatureSuite suite : this.suites) {
            for (String proofType : proofTypes) {
                if (!suite.isSupported(proofType, expandedProof)) continue;
                return suite;
            }
        }
        return null;
    }
}

