/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc.processor;

import com.apicatalog.jsonld.JsonLd;
import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.Term;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.net.URI;

public class ExpandedVerifiable {
    protected JsonStructure context;
    protected DocumentLoader loader;
    protected JsonObject expanded;

    public ExpandedVerifiable(JsonObject expanded, JsonStructure context, DocumentLoader loader) {
        this.expanded = expanded;
        this.loader = loader;
        this.context = context;
    }

    public JsonObject expanded() {
        return this.expanded;
    }

    public JsonObject compacted() throws DocumentError {
        return ExpandedVerifiable.compact(this.expanded(), this.context, this.loader);
    }

    public JsonObject compacted(JsonStructure customContext) throws DocumentError {
        return ExpandedVerifiable.compact(this.expanded(), customContext, this.loader);
    }

    public JsonObject compacted(URI contextLocation) throws DocumentError {
        try {
            return ExpandedVerifiable.postCompact(JsonLd.compact((Document)JsonDocument.of((JsonStructure)this.expanded()), (URI)contextLocation).loader(this.loader).get());
        }
        catch (JsonLdError e) {
            DocumentError.failWithJsonLd(e);
            throw new DocumentError((Throwable)e, DocumentError.ErrorType.Invalid, new Term[0]);
        }
    }

    static JsonObject compact(JsonObject signed, JsonStructure context, DocumentLoader loader) throws DocumentError {
        try {
            return ExpandedVerifiable.postCompact(JsonLd.compact((Document)JsonDocument.of((JsonStructure)signed), (Document)JsonDocument.of((JsonStructure)context)).loader(loader).get());
        }
        catch (JsonLdError e) {
            DocumentError.failWithJsonLd(e);
            throw new DocumentError((Throwable)e, DocumentError.ErrorType.Invalid, new Term[0]);
        }
    }

    static JsonObject postCompact(JsonObject source) {
        JsonObject compacted = source;
        if (!((String)compacted.keySet().iterator().next()).equals("@context")) {
            JsonObjectBuilder builder = Json.createObjectBuilder().add("@context", (JsonValue)JsonUtils.toJsonArray((JsonValue)((JsonValue)compacted.get((Object)"@context"))));
            compacted.entrySet().stream().filter(entry -> !"@context".equals(entry.getKey())).forEach(entry -> builder.add((String)entry.getKey(), (JsonValue)entry.getValue()));
            compacted = builder.build();
        }
        return compacted;
    }
}

