/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc.proof;

import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.vc.VcVocab;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;

public final class EmbeddedProof {
    protected EmbeddedProof() {
    }

    public static final JsonObject addProof(JsonObject document, JsonObject proof) {
        JsonValue propertyValue = (JsonValue)document.get((Object)VcVocab.PROOF.uri());
        JsonArrayBuilder builder = propertyValue == null ? Json.createArrayBuilder() : Json.createArrayBuilder((JsonArray)JsonUtils.toJsonArray((JsonValue)propertyValue));
        return Json.createObjectBuilder((JsonObject)document).add(VcVocab.PROOF.uri(), builder.add(Json.createObjectBuilder().add("@graph", Json.createArrayBuilder().add((JsonValue)proof)))).build();
    }

    public static final JsonObject setProofs(JsonObject document, Collection<JsonObject> proofs) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        proofs.stream().map(proof -> Json.createObjectBuilder().add("@graph", Json.createArrayBuilder().add((JsonValue)proof))).forEach(arg_0 -> ((JsonArrayBuilder)builder).add(arg_0));
        return Json.createObjectBuilder((JsonObject)document).add(VcVocab.PROOF.uri(), builder).build();
    }

    public static Collection<JsonObject> assertProof(JsonObject document) throws DocumentError {
        JsonArray proofValue = document.getJsonArray(VcVocab.PROOF.uri());
        if (proofValue != null && proofValue.size() > 0) {
            ArrayList<JsonObject> proofs = new ArrayList<JsonObject>(proofValue.size());
            for (JsonValue proofGraph : proofValue) {
                if (JsonUtils.isNull((JsonValue)proofGraph)) {
                    throw new DocumentError(DocumentError.ErrorType.Missing, VcVocab.PROOF);
                }
                if (JsonUtils.isNotObject((JsonValue)proofGraph)) {
                    throw new DocumentError(DocumentError.ErrorType.Invalid, VcVocab.PROOF);
                }
                JsonValue proof = (JsonValue)proofGraph.asJsonObject().get((Object)"@graph");
                if (JsonUtils.isNull((JsonValue)proof)) {
                    throw new DocumentError(DocumentError.ErrorType.Missing, VcVocab.PROOF);
                }
                if (JsonUtils.isNotArray((JsonValue)proof) || proof.asJsonArray().size() != 1 || JsonUtils.isNotObject((JsonValue)((JsonValue)proof.asJsonArray().get(0)))) {
                    throw new DocumentError(DocumentError.ErrorType.Invalid, VcVocab.PROOF);
                }
                proofs.add(proof.asJsonArray().getJsonObject(0));
            }
            if (proofs.size() > 0) {
                return proofs;
            }
        }
        throw new DocumentError(DocumentError.ErrorType.Missing, VcVocab.PROOF);
    }

    public static JsonObject removeProofs(JsonObject verifiable) {
        return Json.createObjectBuilder((JsonObject)verifiable).remove(VcVocab.PROOF.uri()).build();
    }
}

