/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc.solid;

import com.apicatalog.ld.signature.CryptoSuite;
import com.apicatalog.ld.signature.LinkedDataSignature;
import com.apicatalog.ld.signature.VerificationError;
import com.apicatalog.vc.proof.ProofValue;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import java.util.Objects;

public class SolidProofValue
implements ProofValue {
    protected final byte[] value;

    public SolidProofValue(byte[] value) {
        this.value = value;
    }

    @Override
    public void verify(CryptoSuite cryptoSuite, JsonStructure context, JsonObject data, JsonObject unsignedProof, byte[] publicKey) throws VerificationError {
        Objects.requireNonNull(this.value);
        Objects.requireNonNull(data);
        Objects.requireNonNull(publicKey);
        if (cryptoSuite == null) {
            throw new VerificationError(VerificationError.Code.UnsupportedCryptoSuite);
        }
        LinkedDataSignature signature = new LinkedDataSignature(cryptoSuite);
        signature.verify(data, unsignedProof, publicKey, this.value);
    }

    @Override
    public byte[] toByteArray() {
        return this.value;
    }
}

