/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc.status;

import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.Term;
import com.apicatalog.ld.node.LdNode;
import com.apicatalog.ld.node.LdType;
import com.apicatalog.vc.VcVocab;
import com.apicatalog.vc.status.StatusValidator;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.net.URI;
import java.util.Collection;

public class StatusPropertiesValidator
implements StatusValidator {
    protected URI id;
    protected Collection<String> type;

    public static StatusPropertiesValidator from(JsonObject document) throws DocumentError {
        StatusPropertiesValidator status = new StatusPropertiesValidator();
        LdNode node = LdNode.of(document);
        status.id = node.id();
        if (status.id == null) {
            throw new DocumentError(DocumentError.ErrorType.Missing, VcVocab.STATUS, Term.ID);
        }
        LdType type = node.type();
        if (!type.exists()) {
            throw new DocumentError(DocumentError.ErrorType.Missing, VcVocab.STATUS, Term.TYPE);
        }
        status.type = type.strings();
        return status;
    }

    public URI getId() {
        return this.id;
    }

    public Collection<String> getType() {
        return this.type;
    }

    @Override
    public void verify(JsonValue status) throws DocumentError, VerifyError {
        if (JsonUtils.isNull((JsonValue)status)) {
            return;
        }
        if (JsonUtils.isObject((JsonValue)status)) {
            StatusPropertiesValidator.from(status.asJsonObject());
        } else if (JsonUtils.isArray((JsonValue)status)) {
            for (JsonValue item : status.asJsonArray()) {
                if (JsonUtils.isObject((JsonValue)item)) {
                    StatusPropertiesValidator.from(item.asJsonObject());
                    continue;
                }
                throw new DocumentError(DocumentError.ErrorType.Invalid, VcVocab.STATUS);
            }
        }
        throw new DocumentError(DocumentError.ErrorType.Invalid, VcVocab.STATUS);
    }
}

