/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc.verifier;

import com.apicatalog.ld.DocumentError;
import com.apicatalog.vc.proof.Proof;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class ProofQueue {
    final Collection<Proof> proofs;
    final Set<URI> ids;

    protected ProofQueue(Collection<Proof> proofs) {
        this.proofs = new ArrayList<Proof>(proofs);
        this.ids = new HashSet<URI>(proofs.size());
    }

    public static final ProofQueue create(Collection<Proof> proofs) {
        return new ProofQueue(proofs);
    }

    public boolean isEmpty() {
        return !this.proofs.isEmpty();
    }

    public Proof pop() throws DocumentError {
        if (this.proofs.isEmpty()) {
            return null;
        }
        for (Proof proof : this.proofs) {
            if (proof.previousProof() != null && !this.ids.contains(proof.previousProof())) continue;
            if (proof.id() != null) {
                if (this.ids.contains(proof.id())) {
                    throw new DocumentError(DocumentError.ErrorType.Invalid, "ProofId");
                }
                this.ids.add(proof.id());
            }
            this.proofs.remove(proof);
            return proof;
        }
        throw new DocumentError(DocumentError.ErrorType.Invalid, "PreviousProofId");
    }
}

