/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc.verifier;

import com.apicatalog.jsonld.JsonLd;
import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.Term;
import com.apicatalog.ld.node.LdType;
import com.apicatalog.ld.signature.VerificationError;
import com.apicatalog.ld.signature.VerificationMethod;
import com.apicatalog.ld.signature.key.VerificationKey;
import com.apicatalog.vc.Credential;
import com.apicatalog.vc.ModelVersion;
import com.apicatalog.vc.Presentation;
import com.apicatalog.vc.VcVocab;
import com.apicatalog.vc.Verifiable;
import com.apicatalog.vc.integrity.DataIntegrityVocab;
import com.apicatalog.vc.processor.AbstractProcessor;
import com.apicatalog.vc.proof.EmbeddedProof;
import com.apicatalog.vc.proof.Proof;
import com.apicatalog.vc.proof.ProofValue;
import com.apicatalog.vc.status.StatusPropertiesValidator;
import com.apicatalog.vc.status.StatusValidator;
import com.apicatalog.vc.subject.SubjectValidator;
import com.apicatalog.vc.suite.SignatureSuite;
import com.apicatalog.vc.verifier.ProofQueue;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public class Verifier
extends AbstractProcessor<Verifier> {
    protected StatusValidator statusValidator = new StatusPropertiesValidator();
    protected SubjectValidator subjectValidator = null;

    protected Verifier(SignatureSuite ... suites) {
        super(suites);
    }

    public static Verifier with(SignatureSuite ... suites) {
        return new Verifier(suites);
    }

    public Verifier statusValidator(StatusValidator statusValidator) {
        this.statusValidator = statusValidator;
        return this;
    }

    public Verifier subjectValidator(SubjectValidator subjectValidator) {
        this.subjectValidator = subjectValidator;
        return this;
    }

    public Verifiable verify(JsonObject document) throws VerificationError, DocumentError {
        Objects.requireNonNull(document);
        return this.verify(document, null, this.getLoader());
    }

    public Verifiable verify(JsonObject document, Map<String, Object> params) throws VerificationError, DocumentError {
        Objects.requireNonNull(document);
        return this.verify(document, params, this.getLoader());
    }

    public Verifiable verify(URI location) throws VerificationError, DocumentError {
        Objects.requireNonNull(location);
        return this.verify(location, null, this.getLoader());
    }

    public Verifiable verify(URI location, Map<String, Object> params) throws VerificationError, DocumentError {
        Objects.requireNonNull(location);
        return this.verify(location, params, this.getLoader());
    }

    protected Verifiable verify(URI location, Map<String, Object> params, DocumentLoader loader) throws VerificationError, DocumentError {
        try {
            DocumentLoaderOptions options = new DocumentLoaderOptions();
            Document loadedDocument = loader.loadDocument(location, options);
            JsonStructure json = (JsonStructure)loadedDocument.getJsonContent().orElseThrow(() -> new DocumentError(DocumentError.ErrorType.Invalid, new Term[0]));
            if (JsonUtils.isNotObject((JsonValue)json)) {
                throw new DocumentError(DocumentError.ErrorType.Invalid, new Term[0]);
            }
            return this.verify(json.asJsonObject(), params, loader);
        }
        catch (JsonLdError e) {
            DocumentError.failWithJsonLd(e);
            throw new DocumentError((Throwable)e, DocumentError.ErrorType.Invalid, new Term[0]);
        }
    }

    protected Verifiable verify(JsonObject document, Map<String, Object> params, DocumentLoader loader) throws VerificationError, DocumentError {
        try {
            JsonArray context = document.containsKey((Object)"@context") ? JsonUtils.toJsonArray((JsonValue)((JsonValue)document.get((Object)"@context"))) : null;
            JsonArray expanded = JsonLd.expand((Document)JsonDocument.of((JsonStructure)document)).loader(loader).base(this.base).get();
            return this.verifyExpanded(Verifiable.getVersion(document), (JsonStructure)context, expanded, params, loader);
        }
        catch (JsonLdError e) {
            DocumentError.failWithJsonLd(e);
            throw new DocumentError((Throwable)e, DocumentError.ErrorType.Invalid, new Term[0]);
        }
    }

    private Verifiable verifyExpanded(ModelVersion version, JsonStructure context, JsonArray expanded, Map<String, Object> params, DocumentLoader loader) throws VerificationError, DocumentError {
        if (expanded == null || expanded.isEmpty() || expanded.size() > 1) {
            throw new DocumentError(DocumentError.ErrorType.Invalid, new Term[0]);
        }
        JsonValue verifiable = (JsonValue)expanded.iterator().next();
        if (JsonUtils.isNotObject((JsonValue)verifiable)) {
            throw new DocumentError(DocumentError.ErrorType.Invalid, new Term[0]);
        }
        return this.verifyExpanded(version, context, verifiable.asJsonObject(), params, loader);
    }

    private Verifiable verifyExpanded(ModelVersion version, JsonStructure context, JsonObject expanded, Map<String, Object> params, DocumentLoader loader) throws VerificationError, DocumentError {
        Verifiable verifiable = Verifiable.of(version, expanded);
        if (verifiable.isCredential()) {
            this.validate(verifiable.asCredential());
            verifiable.proofs(this.verifyProofs(context, expanded, params, loader));
            return verifiable;
        }
        if (verifiable.isPresentation()) {
            verifiable.proofs(this.verifyProofs(context, expanded, params, loader));
            ArrayList<Credential> credentials = new ArrayList<Credential>();
            for (JsonObject presentedCredentials : Presentation.getCredentials(expanded)) {
                if (!Credential.isCredential((JsonValue)presentedCredentials)) {
                    throw new DocumentError(DocumentError.ErrorType.Invalid, VcVocab.VERIFIABLE_CREDENTIALS, Term.TYPE);
                }
                credentials.add(this.verifyExpanded(version, context, presentedCredentials, params, loader).asCredential());
            }
            verifiable.asPresentation().credentials(credentials);
            return verifiable;
        }
        throw new DocumentError(DocumentError.ErrorType.Unknown, Term.TYPE);
    }

    protected Collection<Proof> verifyProofs(JsonStructure context, JsonObject expanded, Map<String, Object> params, DocumentLoader loader) throws VerificationError, DocumentError {
        Collection<JsonObject> expandedProofs = EmbeddedProof.assertProof(expanded);
        JsonObject unsigned = EmbeddedProof.removeProofs(expanded);
        ArrayList<Proof> proofs = new ArrayList<Proof>(expandedProofs.size());
        for (JsonObject expandedProof : expandedProofs) {
            Collection<String> proofTypes = LdType.strings(expandedProof);
            if (proofTypes == null || proofTypes.isEmpty()) {
                throw new DocumentError(DocumentError.ErrorType.Missing, VcVocab.PROOF, Term.TYPE);
            }
            SignatureSuite signatureSuite = this.findSuite(proofTypes, expandedProof);
            if (signatureSuite == null) {
                throw new VerificationError(VerificationError.Code.UnsupportedCryptoSuite);
            }
            Proof proof = signatureSuite.getProof(expandedProof, loader);
            if (proof == null) {
                throw new IllegalStateException("The suite [" + signatureSuite + "] returns null as a proof.");
            }
            proofs.add(proof);
        }
        ProofQueue queue = ProofQueue.create(proofs);
        Proof proof = queue.pop();
        while (proof != null) {
            proof.validate(params);
            ProofValue proofValue = proof.signature();
            if (proofValue == null) {
                throw new DocumentError(DocumentError.ErrorType.Missing, "ProofValue");
            }
            VerificationMethod verificationMethod = this.getMethod(proof, loader).orElseThrow(() -> new DocumentError(DocumentError.ErrorType.Missing, VcVocab.PROOF, DataIntegrityVocab.VERIFICATION_METHOD));
            if (!(verificationMethod instanceof VerificationKey)) {
                throw new DocumentError(DocumentError.ErrorType.Unknown, VcVocab.PROOF, DataIntegrityVocab.VERIFICATION_METHOD);
            }
            proof.verify(context, unsigned, (VerificationKey)verificationMethod);
            proof = queue.pop();
        }
        return proofs;
    }

    final void validate(Credential credential) throws DocumentError, VerificationError {
        if (credential.isExpired()) {
            throw new VerificationError(VerificationError.Code.Expired);
        }
        if (credential.isNotValidYet()) {
            throw new VerificationError(VerificationError.Code.NotValidYet);
        }
        this.validateData(credential);
    }

    protected void validateData(Credential credential) throws DocumentError {
        if ((credential.version() == null || ModelVersion.V11.equals((Object)credential.version())) && credential.issuanceDate() == null) {
            throw new DocumentError(DocumentError.ErrorType.Missing, VcVocab.ISSUANCE_DATE);
        }
        if (this.statusValidator != null && JsonUtils.isNotNull((JsonValue)credential.status())) {
            this.statusValidator.verify(credential.status());
        }
    }
}

