/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld;

import com.apicatalog.jsonld.InvalidJsonLdValue;
import com.apicatalog.jsonld.StringUtils;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.ValueObject;
import com.apicatalog.jsonld.uri.UriUtils;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.net.URI;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;

public class JsonLdReader {
    static final String XSD_DATE_TIME = "http://www.w3.org/2001/XMLSchema#dateTime";

    protected JsonLdReader() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isTypeOf(String type, JsonValue value) {
        if (StringUtils.isBlank((String)type)) {
            throw new IllegalArgumentException("The 'type' parameter must not be null nor blank.");
        }
        if (value == null) {
            throw new IllegalArgumentException("The 'object' parameter must not be null.");
        }
        if (!JsonUtils.isObject((JsonValue)value)) return false;
        if (!value.asJsonObject().containsKey((Object)"@type")) return false;
        if (!JsonUtils.toStream((JsonValue)((JsonValue)value.asJsonObject().get((Object)"@type"))).filter(JsonUtils::isString).map(JsonString.class::cast).map(JsonString::getString).filter(StringUtils::isNotBlank).anyMatch(type::equals)) return false;
        return true;
    }

    public static Collection<String> getType(JsonObject value) {
        if (value == null) {
            throw new IllegalArgumentException("The 'object' parameter must not be null.");
        }
        return JsonUtils.toStream((JsonValue)((JsonValue)value.get((Object)"@type"))).filter(JsonUtils::isString).map(JsonString.class::cast).map(JsonString::getString).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }

    public static boolean hasType(JsonValue expanded) {
        if (expanded == null) {
            throw new IllegalArgumentException("The 'expanded' parameter must not be null.");
        }
        return JsonUtils.isObject((JsonValue)expanded) && expanded.asJsonObject().containsKey((Object)"@type");
    }

    public static boolean isXsdDateTime(JsonValue value) {
        if (value == null) {
            throw new IllegalArgumentException("The 'value' parameter must not be null.");
        }
        return JsonUtils.toStream((JsonValue)value).filter(JsonUtils::isObject).map(JsonValue::asJsonObject).map(o -> JsonLdReader.isTypeOf(XSD_DATE_TIME, (JsonValue)o)).findAny().orElse(false);
    }

    public static boolean hasPredicate(JsonObject subject, String predicate) {
        return JsonUtils.isNotNull((JsonValue)((JsonValue)subject.get((Object)predicate)));
    }

    public static Collection<JsonValue> getObjects(JsonObject subject, String predicate) {
        JsonValue value = (JsonValue)subject.get((Object)predicate);
        if (JsonUtils.isNull((JsonValue)value)) {
            return Collections.emptyList();
        }
        if (JsonUtils.isArray((JsonValue)value) && value.asJsonArray().size() == 1) {
            value = (JsonValue)value.asJsonArray().get(0);
        }
        if (JsonUtils.isObject((JsonValue)value) && value.asJsonObject().containsKey((Object)"@graph") && value.asJsonObject().size() == 1) {
            value = (JsonValue)value.asJsonObject().get((Object)"@graph");
        }
        return JsonUtils.toCollection((JsonValue)value);
    }

    public static Optional<URI> getId(JsonValue subject, String property) throws InvalidJsonLdValue {
        if (JsonUtils.isNotObject((JsonValue)subject) || !JsonLdReader.hasPredicate(subject.asJsonObject(), property)) {
            return Optional.empty();
        }
        Optional<JsonValue> object = JsonLdReader.getObjects(subject.asJsonObject(), property).stream().findFirst();
        if (!object.isPresent()) {
            return Optional.empty();
        }
        JsonValue value = object.get();
        if (JsonUtils.isObject((JsonValue)value)) {
            value = (JsonValue)value.asJsonObject().get((Object)"@id");
        }
        if (JsonUtils.isNull((JsonValue)value)) {
            return Optional.empty();
        }
        if (JsonUtils.isString((JsonValue)value)) {
            String id = ((JsonString)value).getString();
            if (UriUtils.isAbsoluteUri((String)id, (boolean)true)) {
                return Optional.of(URI.create(id));
            }
            throw new InvalidJsonLdValue(property, value, "Property [" + property + "] @id value [" + id + "] is not valid URI.");
        }
        throw new InvalidJsonLdValue(property, value, "Property [" + property + "] @id value [" + value + "] is not JSON string but [" + value.getValueType() + "].");
    }

    public static Optional<Instant> getXsdDateTime(JsonValue subject, String property) throws InvalidJsonLdValue {
        if (JsonUtils.isNotObject((JsonValue)subject) || !JsonLdReader.hasPredicate(subject.asJsonObject(), property)) {
            return Optional.empty();
        }
        Optional<JsonValue> propertyValue = JsonLdReader.getObjects(subject.asJsonObject(), property).stream().findFirst();
        if (!propertyValue.isPresent()) {
            return Optional.empty();
        }
        JsonValue value = propertyValue.get();
        if (JsonLdReader.isXsdDateTime(value)) {
            String datetime = JsonUtils.toStream((JsonValue)value).filter(ValueObject::isValueObject).filter(item -> JsonLdReader.isTypeOf(XSD_DATE_TIME, (JsonValue)item.asJsonObject())).map(ValueObject::getValue).filter(Optional::isPresent).map(Optional::get).filter(JsonUtils::isString).findFirst().map(JsonString.class::cast).map(JsonString::getString).orElseThrow(() -> new InvalidJsonLdValue(property, value, "The property [" + property + "] value is not valid XsdDateTime but [" + value + "]."));
            try {
                return Optional.of(Instant.parse(datetime));
            }
            catch (DateTimeParseException e) {
                throw new InvalidJsonLdValue(property, value, "The property [" + property + "] is not valid XsdDateTime.", e);
            }
        }
        throw new InvalidJsonLdValue(property, value, "The property [" + property + "] @type is not XsdDateTime.");
    }

    public static final Optional<URI> getId(JsonValue subject) throws InvalidJsonLdValue {
        if (subject == null) {
            throw new IllegalArgumentException("The 'value' parameter must not be null.");
        }
        Optional<JsonValue> propertyValue = JsonLdReader.findFirstObject(subject).map(o -> (JsonValue)o.get((Object)"@id"));
        if (!propertyValue.isPresent()) {
            return Optional.empty();
        }
        JsonValue value = propertyValue.get();
        if (JsonUtils.isNull((JsonValue)value)) {
            return Optional.empty();
        }
        if (JsonUtils.isString((JsonValue)value)) {
            String id = ((JsonString)value).getString();
            if (UriUtils.isURI((String)id)) {
                return Optional.of(URI.create(id));
            }
            throw new InvalidJsonLdValue("@id", value, "Property [@id] value [" + id + "] is not valid URI.");
        }
        throw new InvalidJsonLdValue("@id", value, "Property [@id] value [" + value + "] is not JSON string but [" + value.getValueType() + "].");
    }

    public static Optional<JsonObject> findFirstObject(JsonValue expanded) {
        if (JsonUtils.isArray((JsonValue)expanded)) {
            for (JsonValue item : expanded.asJsonArray()) {
                if (!JsonUtils.isObject((JsonValue)item)) continue;
                return Optional.of(item.asJsonObject());
            }
        } else if (JsonUtils.isObject((JsonValue)expanded)) {
            return Optional.of(expanded.asJsonObject());
        }
        return Optional.empty();
    }
}

