/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.ld;

import com.apicatalog.ld.schema.LdTerm;
import java.util.Arrays;

public class DocumentError
extends Throwable {
    private static final long serialVersionUID = -7146533158378348477L;
    private final ErrorType type;
    private final LdTerm[] terms;
    private final String code;

    public DocumentError(ErrorType type, LdTerm ... terms) {
        this.type = type;
        this.terms = terms;
        this.code = DocumentError.toCode(type, terms);
    }

    public DocumentError(Throwable e, ErrorType type, LdTerm ... terms) {
        super(e);
        this.type = type;
        this.terms = terms;
        this.code = DocumentError.toCode(type, terms);
    }

    public ErrorType getType() {
        return this.type;
    }

    public LdTerm[] getTerms() {
        return this.terms;
    }

    public String getCode() {
        return this.code;
    }

    static final String toCode(ErrorType type, LdTerm ... terms) {
        StringBuilder sb = new StringBuilder();
        if (type != null) {
            sb.append(type.name());
        }
        if (terms == null || terms.length == 0) {
            return sb.append("Document").toString();
        }
        Arrays.stream(terms).forEach(term -> {
            int index = term.name().startsWith("@") ? 1 : 0;
            sb.append(Character.toUpperCase(term.name().charAt(index)));
            sb.append(term.name().substring(index + 1));
        });
        return sb.toString();
    }

    public static enum ErrorType {
        Missing,
        Unknown,
        Invalid;

    }
}

