/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.ld.schema;

import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.schema.adapter.LdValueAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class LdPipe<A, B>
implements LdValueAdapter<A, B> {
    private final Collection<LdValueAdapter<Object, Object>> adapters = new ArrayList<LdValueAdapter<Object, Object>>(10);

    protected LdPipe(LdValueAdapter<Object, Object> adapter) {
        this.adapters.add(adapter);
    }

    @Override
    public B read(A value) throws DocumentError {
        Object result = value;
        for (LdValueAdapter<Object, Object> adapter : this.adapters) {
            result = adapter.read(result);
        }
        return (B)result;
    }

    @Override
    public A write(B value) throws DocumentError {
        ArrayList<LdValueAdapter<Object, Object>> reversed = new ArrayList<LdValueAdapter<Object, Object>>(this.adapters);
        Collections.reverse(reversed);
        Object result = value;
        for (LdValueAdapter ldValueAdapter : reversed) {
            result = ldValueAdapter.write(result);
        }
        return (A)result;
    }

    public <C> LdPipe<A, C> map(LdValueAdapter<B, C> adapter) {
        this.adapters.add(adapter);
        return this;
    }

    public static <A, B> LdPipe<A, B> create(LdValueAdapter<A, B> adapter) {
        if (adapter instanceof LdPipe) {
            return (LdPipe)adapter;
        }
        return new LdPipe<A, B>(adapter);
    }
}

