/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.ld.schema;

import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.schema.LdTerm;
import com.apicatalog.ld.schema.ParametrizedPredicate;
import com.apicatalog.ld.schema.adapter.LdValueAdapter;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;

public class LdProperty<T> {
    protected final LdTerm term;
    protected final LdValueAdapter<JsonValue, T> adapter;
    protected final String tag;
    protected boolean mandatory;
    protected Collection<ParametrizedPredicate<T>> predicates;

    public LdProperty(LdTerm term, LdValueAdapter<JsonValue, T> adapter) {
        this(term, adapter, null);
    }

    public LdProperty(LdTerm term, LdValueAdapter<JsonValue, T> adapter, String tag) {
        this.term = term;
        this.adapter = adapter;
        this.tag = tag;
        this.mandatory = false;
    }

    public LdProperty<T> required() {
        this.mandatory = true;
        return this;
    }

    public LdProperty<T> optional() {
        this.mandatory = false;
        return this;
    }

    public LdProperty<T> test(Predicate<T> fnc) {
        return this.test((T v, Map<String, Object> p) -> fnc.test(v));
    }

    public LdProperty<T> test(ParametrizedPredicate<T> fnc) {
        if (this.predicates == null) {
            this.predicates = new ArrayList<ParametrizedPredicate<T>>(5);
        }
        this.predicates.add(fnc);
        return this;
    }

    public LdTerm term() {
        return this.term;
    }

    public JsonValue write(T value) throws DocumentError {
        return this.adapter.write(value);
    }

    public T read(JsonValue value) throws DocumentError {
        return this.adapter.read(value);
    }

    public String tag() {
        return this.tag;
    }

    public boolean validate(T value, Map<String, Object> params) throws DocumentError {
        if (value == null) {
            if (this.mandatory) {
                throw new DocumentError(DocumentError.ErrorType.Missing, this.term);
            }
            return true;
        }
        if (this.predicates == null) {
            return true;
        }
        for (ParametrizedPredicate<T> predicate : this.predicates) {
            if (predicate.test(value, params)) continue;
            throw new DocumentError(DocumentError.ErrorType.Invalid, this.term);
        }
        return true;
    }
}

