/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.ld.schema;

import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.schema.LdObject;
import com.apicatalog.ld.schema.LdPipe;
import com.apicatalog.ld.schema.LdProperty;
import com.apicatalog.ld.schema.LdTerm;
import com.apicatalog.ld.schema.adapter.ArrayAdapter;
import com.apicatalog.ld.schema.adapter.LdValueAdapter;
import com.apicatalog.ld.schema.adapter.LinkAdapter;
import com.apicatalog.ld.schema.adapter.MultibaseAdapter;
import com.apicatalog.ld.schema.adapter.ObjectAdapter;
import com.apicatalog.ld.schema.adapter.StringAdapter;
import com.apicatalog.ld.schema.adapter.UriAdapter;
import com.apicatalog.ld.schema.adapter.ValueObjectAdapter;
import com.apicatalog.ld.schema.adapter.XsdDateTimeAdapter;
import com.apicatalog.multibase.Multibase;
import com.apicatalog.multicodec.Multicodec;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.net.URI;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;

public class LdSchema {
    protected static final LdTerm MULTIBASE_TYPE = LdTerm.create("multibase", "https://w3id.org/security#");
    protected static final String XSD_VOCAB = "http://www.w3.org/2001/XMLSchema#";
    protected static final LdTerm XSD_DATETIME = LdTerm.create("dateTime", "http://www.w3.org/2001/XMLSchema#");
    final ObjectAdapter schema;

    public LdSchema(ObjectAdapter schema) {
        this.schema = schema;
    }

    public <X> LdProperty<X> tagged(String tag) {
        return this.schema.property(tag);
    }

    public LdObject read(JsonObject value) throws DocumentError {
        return this.schema.read((JsonValue)value);
    }

    public void validate(LdObject value, Map<String, Object> params) throws DocumentError {
        this.schema.validate(value, params);
    }

    public JsonObject write(LdObject value) throws DocumentError {
        return this.schema.write(value);
    }

    public <X> LdValueAdapter<JsonValue, X> map(LdValueAdapter<LdObject, X> adapter) {
        return this.schema.map(adapter);
    }

    public static LdSchema create(LdProperty<?> ... properties) {
        return new LdSchema(LdSchema.object(properties));
    }

    public static final ObjectAdapter object(LdProperty<?> ... properties) {
        return ObjectAdapter.create(properties);
    }

    public static final LdProperty<URI> id() {
        return LdSchema.property(LdTerm.ID, LdPipe.create(new StringAdapter()).map(new UriAdapter()));
    }

    public static final LdProperty<URI> type(LdTerm id) {
        return LdSchema.property(LdTerm.TYPE, LdSchema.array(LdPipe.create(new StringAdapter()).map(new UriAdapter())).find(uri -> id.uri().equals(uri.toString())));
    }

    public static final LdProperty<Collection<URI>> type() {
        return LdSchema.property(LdTerm.TYPE, LdSchema.array(LdPipe.create(new StringAdapter()).map(new UriAdapter())));
    }

    public static final <X> LdProperty<X> property(LdTerm id, LdValueAdapter<JsonValue, X> adapter) {
        return new LdProperty<X>(id, adapter);
    }

    public static final <X> LdProperty<X> property(LdTerm id, LdValueAdapter<JsonValue, X> adapter, String tag) {
        return new LdProperty<X>(id, adapter, tag);
    }

    public static final LdValueAdapter<JsonValue, Instant> xsdDateTime() {
        return LdPipe.create(LdSchema.value(XSD_DATETIME, new StringAdapter())).map(new XsdDateTimeAdapter());
    }

    public static final <X> LdValueAdapter<JsonValue, X> value(LdTerm type, LdValueAdapter<JsonValue, X> adapter) {
        return LdPipe.create(new ValueObjectAdapter(type)).map(adapter);
    }

    public static final <X> LdValueAdapter<JsonValue, X> value(LdValueAdapter<JsonValue, X> adapter) {
        return LdPipe.create(new ValueObjectAdapter()).map(adapter);
    }

    public static final LdValueAdapter<JsonValue, String> string() {
        return LdSchema.value(new StringAdapter());
    }

    public static final <X> LdValueAdapter<JsonValue, X> string(LdValueAdapter<String, X> adapter) {
        return LdPipe.create(LdSchema.value(new StringAdapter())).map(adapter);
    }

    public static final LdValueAdapter<JsonValue, URI> link() {
        return new LinkAdapter();
    }

    public static final LdValueAdapter<JsonValue, byte[]> multibase(Multibase.Algorithm algorithm) {
        return LdPipe.create(LdSchema.value(MULTIBASE_TYPE, new StringAdapter())).map(new MultibaseAdapter(algorithm));
    }

    public static final LdValueAdapter<JsonValue, byte[]> multibase(Multibase.Algorithm algorithm, Multicodec.Codec codec) {
        return LdPipe.create(LdSchema.value(MULTIBASE_TYPE, new StringAdapter())).map(new MultibaseAdapter(algorithm, codec));
    }

    public static final LdValueAdapter<JsonValue, URI> uri() {
        return LdSchema.string(new UriAdapter());
    }

    public static final <X> ArrayAdapter<X> array(LdValueAdapter<JsonValue, X> adapter) {
        return new ArrayAdapter<X>(adapter);
    }
}

