/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.ld.schema.adapter;

import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.schema.adapter.ArrayFilter;
import com.apicatalog.ld.schema.adapter.LdValueAdapter;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;

public class ArrayAdapter<T>
implements LdValueAdapter<JsonValue, Collection<T>> {
    protected final LdValueAdapter<JsonValue, T> adapter;

    public ArrayAdapter(LdValueAdapter<JsonValue, T> adapter) {
        this.adapter = adapter;
    }

    @Override
    public Collection<T> read(JsonValue array) throws DocumentError {
        if (JsonUtils.isNull((JsonValue)array)) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (JsonValue value : JsonUtils.toJsonArray((JsonValue)array)) {
            result.add(this.adapter.read(value));
        }
        return result;
    }

    @Override
    public JsonValue write(Collection<T> array) throws DocumentError {
        if (array == null) {
            return JsonValue.NULL;
        }
        JsonArrayBuilder result = Json.createArrayBuilder();
        for (T value : array) {
            result.add(this.adapter.write(value));
        }
        return result.build();
    }

    public LdValueAdapter<JsonValue, T> find(Predicate<T> test) {
        return new ArrayFilter<Object>(this.adapter, (v, p) -> test.test(v));
    }
}

