/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.ld.schema.adapter;

import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.schema.ParametrizedPredicate;
import com.apicatalog.ld.schema.adapter.LdValueAdapter;
import jakarta.json.JsonValue;

public class ArrayFilter<T>
implements LdValueAdapter<JsonValue, T> {
    protected final LdValueAdapter<JsonValue, T> adapter;
    protected final ParametrizedPredicate<T> test;

    public ArrayFilter(LdValueAdapter<JsonValue, T> adapter, ParametrizedPredicate<T> test) {
        this.adapter = adapter;
        this.test = test;
    }

    @Override
    public T read(JsonValue array) throws DocumentError {
        if (JsonUtils.isNull((JsonValue)array)) {
            return null;
        }
        for (JsonValue value : JsonUtils.toJsonArray((JsonValue)array)) {
            T result = this.adapter.read(value);
            if (!this.test.test(result, null)) continue;
            return result;
        }
        return null;
    }

    @Override
    public JsonValue write(T value) throws DocumentError {
        if (value == null) {
            return JsonValue.NULL;
        }
        return this.adapter.write(value);
    }
}

