/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.ld.schema.adapter;

import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.ld.schema.adapter.LdValueAdapter;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.net.URI;

public class LinkAdapter
implements LdValueAdapter<JsonValue, URI> {
    @Override
    public URI read(JsonValue json) {
        if (JsonUtils.isNotObject((JsonValue)json)) {
            throw new IllegalArgumentException();
        }
        JsonObject object = json.asJsonObject();
        JsonValue value = (JsonValue)object.get((Object)"@id");
        if (JsonUtils.isArray((JsonValue)value) && value.asJsonArray().size() == 1) {
            value = (JsonValue)value.asJsonArray().get(0);
        }
        if (JsonUtils.isNotString((JsonValue)value)) {
            throw new IllegalArgumentException();
        }
        return URI.create(((JsonString)value).getString());
    }

    @Override
    public JsonObject write(URI link) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("@id", link.toString());
        return builder.build();
    }
}

