/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.ld.schema.adapter;

import com.apicatalog.ld.schema.adapter.LdValueAdapter;
import com.apicatalog.multibase.Multibase;
import com.apicatalog.multicodec.Multicodec;

public class MultibaseAdapter
implements LdValueAdapter<String, byte[]> {
    protected final Multibase.Algorithm algorithm;
    protected final Multicodec.Codec codec;

    public MultibaseAdapter(Multibase.Algorithm algorithm) {
        this(algorithm, null);
    }

    public MultibaseAdapter(Multibase.Algorithm algorithm, Multicodec.Codec codec) {
        this.algorithm = algorithm;
        this.codec = codec;
    }

    @Override
    public byte[] read(String value) {
        byte[] debased = Multibase.decode((String)value);
        if (this.codec == null) {
            return debased;
        }
        return Multicodec.decode((Multicodec.Codec)this.codec, (byte[])debased);
    }

    @Override
    public String write(byte[] value) {
        if (this.codec == null) {
            return Multibase.encode((Multibase.Algorithm)this.algorithm, (byte[])value);
        }
        return Multibase.encode((Multibase.Algorithm)this.algorithm, (byte[])Multicodec.encode((Multicodec.Codec)this.codec, (byte[])value));
    }
}

