/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.ld.schema.adapter;

import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.schema.LdObject;
import com.apicatalog.ld.schema.LdPipe;
import com.apicatalog.ld.schema.LdProperty;
import com.apicatalog.ld.schema.LdTerm;
import com.apicatalog.ld.schema.adapter.LdValueAdapter;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class ObjectAdapter
implements LdValueAdapter<JsonValue, LdObject> {
    protected final Map<String, LdProperty<Object>> terms;
    protected final Map<String, LdProperty<Object>> tags;

    protected ObjectAdapter(Map<String, LdProperty<Object>> terms, Map<String, LdProperty<Object>> tags) {
        this.terms = terms;
        this.tags = tags;
    }

    @Override
    public LdObject read(JsonValue json) throws DocumentError {
        if (JsonUtils.isNotObject((JsonValue)json)) {
            throw new IllegalArgumentException();
        }
        JsonObject object = json.asJsonObject();
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>(object.size());
        for (Map.Entry entry : object.entrySet()) {
            if (!this.terms.containsKey(entry.getKey())) continue;
            JsonValue jsonValue = (JsonValue)entry.getValue();
            if (JsonUtils.isArray((JsonValue)jsonValue) && jsonValue.asJsonArray().size() == 1) {
                jsonValue = (JsonValue)jsonValue.asJsonArray().get(0);
            }
            LdProperty<Object> property = this.terms.get(entry.getKey());
            if (JsonUtils.isNull((JsonValue)jsonValue)) continue;
            try {
                values.put((String)entry.getKey(), property.read(jsonValue));
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                throw new DocumentError(e, DocumentError.ErrorType.Invalid, property.term());
            }
        }
        return new LdObject(Collections.unmodifiableMap(values));
    }

    @Override
    public JsonObject write(LdObject object) throws DocumentError {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (Map.Entry<String, Object> entry : object.entrySet()) {
            if (entry.getValue() == null || !this.terms.containsKey(entry.getKey())) continue;
            LdProperty<Object> property = this.terms.get(entry.getKey());
            JsonValue value = property.write(entry.getValue());
            if (!"@id".equalsIgnoreCase(entry.getKey())) {
                value = Json.createArrayBuilder().add(value).build();
            }
            builder.add(entry.getKey(), value);
        }
        return builder.build();
    }

    public static ObjectAdapter create(LdProperty<?>[] properties) {
        LinkedHashMap terms = new LinkedHashMap(properties.length);
        LinkedHashMap tags = new LinkedHashMap(5);
        for (LdProperty<?> property : properties) {
            if (property.tag() != null) {
                tags.put(property.tag(), property);
            }
            terms.put(property.term().uri(), property);
        }
        return new ObjectAdapter(Collections.unmodifiableMap(terms), Collections.unmodifiableMap(tags));
    }

    public <X> LdProperty<X> property(String tag) {
        return this.tags.get(tag);
    }

    public boolean contains(LdTerm term) {
        return this.terms.containsKey(term.uri());
    }

    public void validate(LdObject object, Map<String, Object> params) throws DocumentError {
        for (LdProperty<Object> property : this.terms.values()) {
            Object value = null;
            if (object.contains(property.term())) {
                value = object.value(property.term());
            }
            property.validate(value, params);
        }
    }

    public <T> LdValueAdapter<JsonValue, T> map(LdValueAdapter<LdObject, T> adapter) {
        return LdPipe.create(this).map(adapter);
    }
}

